/*
 * Decompiled with CFR 0.152.
 */
package net.riotopsys.factotum.compiler;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

public class Util {
    private Util() {
    }

    public static PackageElement getPackageElement(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static String ucaseFirstCharacter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static TypeElement getParameterElement(VariableElement parameterElement, ProcessingEnvironment processingEnv) {
        TypeMirror parameterType = parameterElement.asType();
        Types typeUtils = processingEnv.getTypeUtils();
        return (TypeElement)typeUtils.asElement(parameterType);
    }

    public static boolean hasVoidReturn(ExecutableElement element) {
        return element.getReturnType().getKind().equals((Object)TypeKind.VOID);
    }

    public static TypeElement mirrorTypeToElementType(TypeMirror parameterType, ProcessingEnvironment processingEnv) {
        Types typeUtils = processingEnv.getTypeUtils();
        return (TypeElement)typeUtils.asElement(parameterType);
    }

    public static TypeElement getTypeElement(Element element) {
        while (element != null && element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    public static boolean isPublicEnough(Element element) {
        return !element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public static boolean hasDefaultConstructor(TypeElement type) {
        for (ExecutableElement cons : ElementFilter.constructorsIn(type.getEnclosedElements())) {
            if (!cons.getParameters().isEmpty() || !Util.isPublicEnough(cons)) continue;
            return true;
        }
        return false;
    }
}

