/*
 * Decompiled with CFR 0.152.
 */
package net.riotopsys.factotum.compiler;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import net.riotopsys.factotum.api.annotation.Task;
import net.riotopsys.factotum.compiler.RequestWriter;
import net.riotopsys.factotum.compiler.Util;

@SupportedAnnotationTypes(value={"net.riotopsys.factotum.api.annotation.Task"})
@AutoService(value=Processor.class)
public class TaskProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(Task.class)) {
                TypeElement typeElement = Util.getTypeElement(element);
                if (typeElement.getKind() == ElementKind.INTERFACE) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Annotation (%s) not supported on interfaces (%s)", Task.class.getCanonicalName(), typeElement.getQualifiedName().toString()), element);
                    continue;
                }
                if (!Util.hasDefaultConstructor(typeElement)) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Annotation (%s) requires a default non private constructor in class (%s)", Task.class.getCanonicalName(), typeElement.getQualifiedName().toString()), element);
                    continue;
                }
                if (typeElement.getTypeParameters().size() > 0) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Annotation (%s) not supported on templatized type (%s)", Task.class.getCanonicalName(), typeElement.getQualifiedName().toString()), element);
                    continue;
                }
                if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Annotation (%s) not supported on Abstract class (%s)", Task.class.getCanonicalName(), typeElement.getQualifiedName().toString()), element);
                    continue;
                }
                if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Annotation (%s) not supported on private methods", Task.class.getCanonicalName()), element);
                    continue;
                }
                new RequestWriter(this.processingEnv, (ExecutableElement)element).write();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }
}

