/*
 * Decompiled with CFR 0.152.
 */
package net.riotopsys.factotum.compiler;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.tools.JavaFileObject;
import net.riotopsys.factotum.api.AbstractRequest;
import net.riotopsys.factotum.api.annotation.Task;
import net.riotopsys.factotum.api.interfaces.ICallback;
import net.riotopsys.factotum.compiler.Util;

public class RequestWriter {
    private final ProcessingEnvironment processingEnv;
    private final ExecutableElement elem;
    private String packageName;
    private String handlerClass;
    private String requestName;
    private List<ParameterPair> parameters = new ArrayList<ParameterPair>();
    private String returnDef;
    private HashSet<String> imports = new HashSet();
    private boolean isVoidReturn;

    public RequestWriter(ProcessingEnvironment processingEnv, ExecutableElement elem) {
        this.processingEnv = processingEnv;
        this.elem = elem;
        this.imports.add(AbstractRequest.class.getCanonicalName());
        this.imports.add(ICallback.class.getCanonicalName());
        this.imports.add(WeakReference.class.getCanonicalName());
        this.isVoidReturn = Util.hasVoidReturn(elem);
        this.buildPackage(elem);
        this.buildHandlerClass();
        this.buildRequestName();
        this.buildParameters();
        if (!this.isVoidReturn) {
            this.returnDef = this.buildTypeDef(elem.getReturnType());
        }
    }

    private void buildParameters() {
        for (VariableElement variableElement : this.elem.getParameters()) {
            TypeElement paramType = Util.getParameterElement(variableElement, this.processingEnv);
            TypeMirror parameterType = variableElement.asType();
            this.parameters.add(new ParameterPair(this.buildTypeDef(parameterType), variableElement.getSimpleName().toString()));
        }
    }

    public void write() throws IOException {
        JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(this.packageName + '.' + this.requestName, new Element[0]);
        JavaWriter jw = new JavaWriter(jfo.openWriter());
        jw.emitPackage(this.packageName).emitImports(this.imports).beginType(this.requestName, "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), AbstractRequest.class.getSimpleName(), new String[0]);
        for (ParameterPair parameterPair : this.parameters) {
            jw.emitField(parameterPair.type, parameterPair.name, EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
        }
        jw.beginConstructor(EnumSet.of(Modifier.PUBLIC), this.constructorParameters().toArray(new String[this.parameters.size() * 2]));
        for (VariableElement variableElement : this.elem.getParameters()) {
            jw.emitStatement("this.%1$s = %1$s", new Object[]{variableElement.getSimpleName().toString()});
        }
        jw.endConstructor().emitAnnotation(Override.class).beginMethod("Object", "getTaskHandler", EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("return new %s()", new Object[]{this.handlerClass}).endMethod();
        if (Util.hasVoidReturn(this.elem)) {
            this.createVoidExecute(this.elem, this.handlerClass, this.parameterNames(), jw);
        } else {
            this.createNormalExecute(this.elem, this.handlerClass, this.parameterNames(), jw);
            jw.beginMethod(this.requestName, "setCallback", EnumSet.of(Modifier.PUBLIC), new String[]{String.format("%s<%s>", ICallback.class.getSimpleName(), this.returnDef), "callback"}).emitStatement("callbackRef = new WeakReference<ICallback>(callback)", new Object[0]).emitStatement("return this", new Object[0]).endMethod();
        }
        jw.beginMethod(this.requestName, "setGroup", EnumSet.of(Modifier.PUBLIC), new String[]{"Object", "group"}).emitStatement("this.group = group", new Object[0]).emitStatement("return this", new Object[0]).endMethod();
        jw.beginMethod(this.requestName, "setPriority", EnumSet.of(Modifier.PUBLIC), new String[]{"int", "priority"}).emitStatement("this.priority = priority", new Object[0]).emitStatement("return this", new Object[0]).endMethod();
        jw.endType().close();
    }

    private String buildTypeDef(TypeMirror mirrorReturnType) {
        if (mirrorReturnType.getKind() == TypeKind.WILDCARD) {
            TypeMirror wildType = ((WildcardType)mirrorReturnType).getSuperBound();
            if (wildType != null) {
                return String.format("? super %s", this.buildTypeDef(wildType));
            }
            wildType = ((WildcardType)mirrorReturnType).getExtendsBound();
            if (wildType != null) {
                return String.format("? extends %s", this.buildTypeDef(wildType));
            }
            throw new RuntimeException("unsupported wildcard?");
        }
        TypeElement returnType = Util.mirrorTypeToElementType(mirrorReturnType, this.processingEnv);
        this.addImport(returnType);
        ArrayList<String> argTypes = new ArrayList<String>();
        for (TypeMirror typeMirror : ((DeclaredType)mirrorReturnType).getTypeArguments()) {
            argTypes.add(this.buildTypeDef(typeMirror));
        }
        String result = argTypes.size() > 0 ? String.format("%s<%s>", returnType.getSimpleName().toString(), Joiner.on((String)", ").join(argTypes)) : returnType.getSimpleName().toString();
        return result;
    }

    private void buildHandlerClass() {
        this.handlerClass = this.elem.getEnclosingElement().getSimpleName().toString();
    }

    public List<String> constructorParameters() {
        ArrayList<String> result = new ArrayList<String>();
        for (ParameterPair pair : this.parameters) {
            result.add(pair.type);
            result.add(pair.name);
        }
        return result;
    }

    public List<String> parameterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ParameterPair pair : this.parameters) {
            result.add(pair.name);
        }
        return result;
    }

    private void addImport(TypeElement paramType) {
        PackageElement paramaterPackage = Util.getPackageElement(paramType);
        if (!this.packageName.equals(paramaterPackage.getQualifiedName().toString()) && !"java.lang".equals(paramaterPackage.getQualifiedName().toString())) {
            this.imports.add(paramType.getQualifiedName().toString());
        }
    }

    private void buildRequestName() {
        Task taskAnnotation = this.elem.getAnnotation(Task.class);
        this.requestName = taskAnnotation.requestName();
        if (this.requestName.equals("")) {
            this.requestName = Util.ucaseFirstCharacter(this.elem.getSimpleName().toString()) + "Request";
        }
    }

    private void buildPackage(ExecutableElement elem) {
        PackageElement packageElem = Util.getPackageElement(elem);
        this.packageName = packageElem.getQualifiedName().toString();
    }

    private void createNormalExecute(ExecutableElement elem, String parentClass, List<String> parameterNames, JavaWriter jw) throws IOException {
        jw.emitAnnotation(Override.class).beginMethod("Object", "execute", EnumSet.of(Modifier.PUBLIC), (List)Lists.newArrayList((Object[])new String[]{"Object", "handler"}), (List)Lists.newArrayList((Object[])new String[]{"Exception"})).beginControlFlow("if ( isCanceled() )").emitStatement("return null", new Object[0]).endControlFlow().emitStatement("return ((%s)handler).%s(%s)", new Object[]{parentClass, elem.getSimpleName().toString(), Joiner.on((String)", ").join(parameterNames)}).endMethod();
    }

    private void createVoidExecute(ExecutableElement elem, String parentClass, List<String> parameterNames, JavaWriter jw) throws IOException {
        jw.emitAnnotation(Override.class).beginMethod("Object", "execute", EnumSet.of(Modifier.PUBLIC), (List)Lists.newArrayList((Object[])new String[]{"Object", "handler"}), (List)Lists.newArrayList((Object[])new String[]{"Exception"})).beginControlFlow("if ( isCanceled() )").emitStatement("return null", new Object[0]).endControlFlow().emitStatement("((%s)handler).%s(%s)", new Object[]{parentClass, elem.getSimpleName().toString(), Joiner.on((String)", ").join(parameterNames)}).emitStatement("return null", new Object[0]).endMethod();
    }

    private static class ParameterPair {
        public String type;
        public String name;

        public ParameterPair(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }
}

