/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Random;
import net.renfei.unifiauth.sdk.utils.EncryptionUtils;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final String NULLSTR = "";
    private static final char SEPARATOR = '_';
    private static final String EMAIL_REGEX = "^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$";
    private static final String CHINA_PHONE_ALL = "^(?:\\+?86)?1(?:3\\d{3}|5[^4\\D]\\d{2}|8\\d{3}|7(?:[35-8]\\d{2}|4(?:0\\d|1[0-2]|9\\d))|9[0135-9]\\d{2}|66\\d{2})\\d{6}$";
    private static final String CHINA_PHONE_CHINA_MOBILE = "^(?:\\+?86)?1(?:3(?:4[^9\\D]|[5-9]\\d)|5[^3-6\\D]\\d|8[23478]\\d|[79]8\\d)\\d{7}$";
    private static final String CHINA_PHONE_CHINA_UNICOM = "^(?:\\+?86)?1(?:3[0-2]|[578][56]|66)\\d{8}$";
    private static final String CHINA_PHONE_CHINA_TELECOM = "^(?:\\+?86)?1(?:3(?:3\\d|49)\\d|53\\d{2}|8[019]\\d{2}|7(?:[37]\\d{2}|40[0-5])|9[139]\\d{2})\\d{6}$";
    private static final String CHINA_PHONE_MVNO_ALL = "^(?:\\+?86)?1(?:7[01]|6[257])\\d{8}$";
    private static final String DOMAIN_REGEX = "^(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\\.)+[a-z0-9][a-z0-9-]{0,61}[a-z0-9]$";

    public static boolean isDomain(String domain) {
        if (domain == null || NULLSTR.equals(domain)) {
            return false;
        }
        return domain.matches(DOMAIN_REGEX);
    }

    public static boolean isEmail(String email) {
        if (email == null || NULLSTR.equals(email)) {
            return false;
        }
        return email.matches(EMAIL_REGEX);
    }

    public static boolean isChinaPhone(String phone) {
        if (phone == null || NULLSTR.equals(phone)) {
            return false;
        }
        return phone.matches(CHINA_PHONE_ALL);
    }

    public static boolean isChinaMobilePhone(String phone) {
        if (phone == null || NULLSTR.equals(phone)) {
            return false;
        }
        return phone.matches(CHINA_PHONE_CHINA_MOBILE);
    }

    public static boolean isChinaUnicomePhone(String phone) {
        if (phone == null || NULLSTR.equals(phone)) {
            return false;
        }
        return phone.matches(CHINA_PHONE_CHINA_UNICOM);
    }

    public static boolean isChinaTelecomPhone(String phone) {
        if (phone == null || NULLSTR.equals(phone)) {
            return false;
        }
        return phone.matches(CHINA_PHONE_CHINA_TELECOM);
    }

    public static boolean isChinaMvnoPhone(String phone) {
        if (phone == null || NULLSTR.equals(phone)) {
            return false;
        }
        return phone.matches(CHINA_PHONE_MVNO_ALL);
    }

    public static String signature(String ... arr) {
        if (arr == null || arr.length < 1) {
            return null;
        }
        Arrays.sort(arr);
        StringBuilder sb = new StringBuilder();
        for (String param : arr) {
            sb.append(param);
        }
        return EncryptionUtils.encrypt("SHA1", sb.toString());
    }

    public static String getRandomString(int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            int number = random.nextInt(3);
            long result = 0L;
            switch (number) {
                case 0: {
                    result = Math.round(Math.random() * 25.0 + 65.0);
                    sb.append((char)result);
                    continue block5;
                }
                case 1: {
                    result = Math.round(Math.random() * 25.0 + 97.0);
                    sb.append((char)result);
                    continue block5;
                }
                case 2: {
                    sb.append(new Random().nextInt(10));
                    continue block5;
                }
            }
        }
        return sb.toString();
    }

    public static String getRandomNumber(int length) {
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            rs.append(r.nextInt(10));
        }
        return rs.toString();
    }

    public static String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBase64(String str) {
        return Base64.getDecoder().decode(str);
    }

    public static String encodeUTF8StringBase64(String str) {
        String encoded = null;
        try {
            encoded = Base64.getEncoder().encodeToString(str.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    public static String decodeUTF8StringBase64(String str) {
        String decoded = null;
        byte[] bytes = Base64.getDecoder().decode(str);
        try {
            decoded = new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    public static String encodeURL(String url) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    public static String decodeURL(String url) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    public static String delHtmlTags(String htmlStr) {
        String scriptRegex = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String styleRegex = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String htmlRegex = "<[^>]+>";
        String spaceRegex = "\\s*|\t|\r|\n";
        htmlStr = htmlStr.replaceAll(scriptRegex, NULLSTR);
        htmlStr = htmlStr.replaceAll(styleRegex, NULLSTR);
        htmlStr = htmlStr.replaceAll(htmlRegex, NULLSTR);
        htmlStr = htmlStr.replaceAll(spaceRegex, NULLSTR);
        return htmlStr.trim();
    }

    public static BigInteger stringToBigInt(String ipInString) {
        byte[] bytes = (ipInString = ipInString.replace(" ", NULLSTR)).contains(":") ? StringUtils.ipv6ToBytes(ipInString) : StringUtils.ipv4ToBytes(ipInString);
        return new BigInteger(bytes);
    }

    public static String bigIntToString(BigInteger ipInBigInt) {
        byte[] bytes = ipInBigInt.toByteArray();
        byte[] unsignedBytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        if (bytes.length == 4 || bytes.length == 16) {
            unsignedBytes = bytes;
        }
        try {
            String ip = InetAddress.getByAddress(unsignedBytes).toString();
            return ip.substring(ip.indexOf(47) + 1).trim();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return StringUtils.isNull(coll) || coll.isEmpty();
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private static byte[] ipv6ToBytes(String ipv6) {
        byte[] ret = new byte[17];
        ret[0] = 0;
        int ib = 16;
        boolean comFlag = false;
        if (ipv6.startsWith(":")) {
            ipv6 = ipv6.substring(1);
        }
        String[] groups = ipv6.split(":");
        for (int ig = groups.length - 1; ig > -1; --ig) {
            if (groups[ig].contains(".")) {
                byte[] temp = StringUtils.ipv4ToBytes(groups[ig]);
                ret[ib--] = temp[4];
                ret[ib--] = temp[3];
                ret[ib--] = temp[2];
                ret[ib--] = temp[1];
                comFlag = true;
                continue;
            }
            if (NULLSTR.equals(groups[ig])) {
                int zlg = 9 - (groups.length + (comFlag ? 1 : 0));
                while (zlg-- > 0) {
                    ret[ib--] = 0;
                    ret[ib--] = 0;
                }
                continue;
            }
            int temp = Integer.parseInt(groups[ig], 16);
            ret[ib--] = (byte)temp;
            ret[ib--] = (byte)(temp >> 8);
        }
        return ret;
    }

    private static byte[] ipv4ToBytes(String ipv4) {
        byte[] ret = new byte[5];
        ret[0] = 0;
        int position1 = ipv4.indexOf(".");
        int position2 = ipv4.indexOf(".", position1 + 1);
        int position3 = ipv4.indexOf(".", position2 + 1);
        ret[1] = (byte)Integer.parseInt(ipv4.substring(0, position1));
        ret[2] = (byte)Integer.parseInt(ipv4.substring(position1 + 1, position2));
        ret[3] = (byte)Integer.parseInt(ipv4.substring(position2 + 1, position3));
        ret[4] = (byte)Integer.parseInt(ipv4.substring(position3 + 1));
        return ret;
    }
}

