/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import net.renfei.unifiauth.sdk.utils.StringUtils;

@Schema(title="\u7edf\u4e00\u63a5\u53e3\u54cd\u5e94\u5bf9\u8c61")
public class ApiResult<T>
implements Serializable {
    private static final long serialVersionUID = -3316408227872898096L;
    @Schema(description="\u72b6\u6001\u7801\uff0c\u6210\u529f\u4e3a200")
    private Integer code;
    @Schema(description="\u6d88\u606f")
    private String message;
    @Schema(description="\u670d\u52a1\u5668\u65f6\u95f4\u6233")
    private Integer timestamp;
    @Schema(description="\u7b7e\u540d")
    private String signature;
    @Schema(description="\u968f\u673a\u6570")
    private String nonce;
    @Schema(description="\u6570\u636e\u8d1f\u8f7d")
    private T data;

    private ApiResult() {
        this.signature();
    }

    private ApiResult(Builder<T> builder) {
        this.code = ((Builder)builder).code;
        this.message = ((Builder)builder).message;
        this.data = ((Builder)builder).data;
        this.signature();
    }

    public ApiResult(T data) {
        this.code = 200;
        this.message = "Success.";
        this.data = data;
        this.signature();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ApiResult<?> success() {
        ApiResult apiResult = new ApiResult();
        apiResult.code = 200;
        apiResult.message = "Success.";
        return apiResult;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public Integer getTimestamp() {
        return this.timestamp;
    }

    public T getData() {
        return this.data;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNonce() {
        return this.nonce;
    }

    private void setNonce(String nonce) {
        this.nonce = nonce;
    }

    private void signature() {
        this.timestamp = (int)(System.currentTimeMillis() / 1000L);
        this.nonce = StringUtils.getRandomString(16);
        this.signature = StringUtils.signature(this.timestamp.toString(), this.nonce);
    }

    /* synthetic */ ApiResult(Builder x0, 1 x1) {
        this(x0);
    }

    public static class Builder<T> {
        private Integer code;
        private String message;
        private T data;

        public Builder<T> code(int code) {
            this.code = code;
            return this;
        }

        public Builder<T> message(String message) {
            this.message = message;
            return this;
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ApiResult<T> build() {
            return new ApiResult(this, null);
        }
    }
}

