/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.constant;

public enum SecretLevelEnum {
    UNCLASSIFIED(0),
    INTERNAL(1),
    SECRET(2),
    CONFIDENTIAL(3);

    private final int LEVEL;

    private SecretLevelEnum(int level) {
        this.LEVEL = level;
    }

    public int getLevel() {
        return this.LEVEL;
    }

    public static SecretLevelEnum valueOf(int level) {
        switch (level) {
            case 2: {
                return SECRET;
            }
            case 3: {
                return CONFIDENTIAL;
            }
        }
        return UNCLASSIFIED;
    }

    public static boolean outOfSecretLevel(SecretLevelEnum source, SecretLevelEnum target) {
        return target.getLevel() > source.getLevel();
    }
}

