/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.utils;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(URI uri, String token) {
        HttpGet request = new HttpGet(uri);
        if (token.startsWith("Bearer ")) {
            request.setHeader("Authorization", token);
        } else {
            request.setHeader("Authorization", "Bearer " + token);
        }
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            Throwable throwable;
            CloseableHttpResponse response;
            block27: {
                String string;
                block28: {
                    response = httpClient.execute((HttpUriRequest)request);
                    throwable = null;
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block27;
                    string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                    if (response == null) return string;
                    if (throwable == null) break block28;
                    try {
                        response.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return string;
                    }
                }
                response.close();
                return string;
            }
            try {
                try {
                    throw new RuntimeException("response entity is null.");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (response == null) throw throwable4;
                if (throwable == null) {
                    response.close();
                    throw throwable4;
                }
                try {
                    response.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String postForm(URI uri, String clientId, String password, Map<String, String> data) {
        final HttpHost target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)new BasicAuthCache(){
            {
                this.put(target, (AuthScheme)new BasicScheme());
            }
        });
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(clientId, password));
        ArrayList formParams = new ArrayList();
        data.forEach((key, value) -> formParams.add(new BasicNameValuePair(key, value)));
        HttpPost request = new HttpPost(uri);
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, Consts.UTF_8));
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();){
            Throwable throwable;
            CloseableHttpResponse response;
            block25: {
                String string;
                block26: {
                    response = httpClient.execute(target, (HttpRequest)request, (HttpContext)localContext);
                    throwable = null;
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block25;
                    string = EntityUtils.toString((HttpEntity)entity);
                    if (response == null) return string;
                    if (throwable == null) break block26;
                    try {
                        response.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return string;
                    }
                }
                response.close();
                return string;
            }
            try {
                try {
                    throw new RuntimeException("response entity is null.");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (response == null) throw throwable4;
                if (throwable == null) {
                    response.close();
                    throw throwable4;
                }
                try {
                    response.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

