/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.List;
import net.renfei.unifiauth.sdk.UnifiAuthClient;
import net.renfei.unifiauth.sdk.entity.ApiResult;
import net.renfei.unifiauth.sdk.entity.ApplicationDetail;
import net.renfei.unifiauth.sdk.entity.ListData;
import net.renfei.unifiauth.sdk.entity.MenuDetail;
import net.renfei.unifiauth.sdk.entity.RoleDetail;
import net.renfei.unifiauth.sdk.entity.UserDetail;
import net.renfei.unifiauth.sdk.entity.UserProfile;
import net.renfei.unifiauth.sdk.utils.HttpClientUtils;
import net.renfei.unifiauth.sdk.utils.JSONUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class UserService {
    private final UnifiAuthClient UNIFI_AUTH_CLIENT;

    public UserService(UnifiAuthClient unifiAuthClient) {
        this.UNIFI_AUTH_CLIENT = unifiAuthClient;
    }

    public UserProfile queryUserProfile(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/profile");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<UserProfile> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<UserProfile>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }

    public List<RoleDetail> queryUserRoleList(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/roles");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<List<RoleDetail>> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<List<RoleDetail>>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }

    public List<MenuDetail> queryUserMenuTree(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/menus");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<List<MenuDetail>> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<List<MenuDetail>>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }

    public List<ApplicationDetail> queryUserApplications(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/applications");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<List<ApplicationDetail>> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<List<ApplicationDetail>>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }

    public ListData<UserDetail> queryUserList(String token, String username, String name, String phone, String email, Integer pages, Integer rows) throws Exception {
        URI uri;
        HttpClientUtils httpClientUtils;
        String result;
        ApiResult<ListData<UserDetail>> apiResult;
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/user");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url.toString());
        if (StringUtils.hasLength((String)username)) {
            uriComponentsBuilder.queryParam("username", new Object[]{username});
        }
        if (StringUtils.hasLength((String)name)) {
            uriComponentsBuilder.queryParam("name", new Object[]{name});
        }
        if (StringUtils.hasLength((String)phone)) {
            uriComponentsBuilder.queryParam("phone", new Object[]{phone});
        }
        if (StringUtils.hasLength((String)email)) {
            uriComponentsBuilder.queryParam("email", new Object[]{email});
        }
        if (pages != null) {
            uriComponentsBuilder.queryParam("pages", new Object[]{pages});
        }
        if (rows != null) {
            uriComponentsBuilder.queryParam("rows", new Object[]{rows});
        }
        if ((apiResult = JSONUtils.json2pojo(result = (httpClientUtils = new HttpClientUtils()).get(uri = uriComponentsBuilder.build().toUri(), token), new TypeReference<ApiResult<ListData<UserDetail>>>(){})).getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }
}

