/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JSONUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper getInstance() {
        return OBJECT_MAPPER;
    }

    public static String obj2json(Object obj) throws Exception {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    public static String obj2jsonIgnoreNull(Object obj) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writeValueAsString(obj);
    }

    public static <T> T json2pojo(String jsonString, Class<T> clazz) throws Exception {
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return (T)OBJECT_MAPPER.readValue(jsonString, clazz);
    }

    public static <T> T json2pojo(String jsonArrayStr, TypeReference<T> typeReference) throws Exception {
        return (T)OBJECT_MAPPER.readValue(jsonArrayStr, typeReference);
    }

    public static Map<String, Object> json2map(String jsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return (Map)mapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static <T> Map<String, T> json2map(String jsonString, Class<T> clazz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Map map = (Map)mapper.readValue(jsonString, new TypeReference<Map<String, T>>(){});
        return map;
    }

    public static Map<String, Object> json2mapDeeply(String json) throws Exception {
        return JSONUtils.json2MapRecursion(json, OBJECT_MAPPER);
    }

    private static List<Object> json2ListRecursion(String json, ObjectMapper mapper) throws Exception {
        if (json == null) {
            return null;
        }
        List list = (List)mapper.readValue(json, List.class);
        for (Object obj : list) {
            if (obj == null || !(obj instanceof String)) continue;
            String str = (String)obj;
            if (str.startsWith("[")) {
                obj = JSONUtils.json2ListRecursion(str, mapper);
                continue;
            }
            if (!obj.toString().startsWith("{")) continue;
            obj = JSONUtils.json2MapRecursion(str, mapper);
        }
        return list;
    }

    public static <T> T json2ObjectList(String json, Class<T> valueType) throws IOException {
        ObjectMapper mapper = JSONUtils.getInstance();
        return (T)mapper.readValue(json, valueType);
    }

    private static Map<String, Object> json2MapRecursion(String json, ObjectMapper mapper) throws Exception {
        if (json == null) {
            return null;
        }
        Map map = (Map)mapper.readValue(json, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj == null || !(obj instanceof String)) continue;
            String str = (String)obj;
            if (str.startsWith("[")) {
                List<Object> list = JSONUtils.json2ListRecursion(str, mapper);
                map.put(entry.getKey(), list);
                continue;
            }
            if (!str.startsWith("{")) continue;
            Map<String, Object> mapRecursion = JSONUtils.json2MapRecursion(str, mapper);
            map.put(entry.getKey(), mapRecursion);
        }
        return map;
    }

    public static <T> List<T> json2list(String jsonArrayStr) throws Exception {
        List lst = (List)OBJECT_MAPPER.readValue(jsonArrayStr, List.class);
        return lst;
    }

    public static <T> List<T> json2list(String jsonArrayStr, TypeReference<List<T>> typeReference) throws Exception {
        List lst = (List)OBJECT_MAPPER.readValue(jsonArrayStr, typeReference);
        return lst;
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return OBJECT_MAPPER.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> T map2pojo(Map map, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue((Object)map, clazz);
    }

    public static String mapToJson(Map map) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String objectToJson(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static <T> T obj2pojo(Object obj, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue(obj, clazz);
    }

    static {
        OBJECT_MAPPER.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        SimpleModule module = new SimpleModule("DoubleSerializer", new Version(1, 0, 0, ""));
        module.addSerializer(Double.class, (JsonSerializer)new DoubleSerializer());
        module.addSerializer(Double.TYPE, (JsonSerializer)new DoubleSerializer());
        OBJECT_MAPPER.registerModule((Module)javaTimeModule).registerModule((Module)module).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class DoubleSerializer
    extends JsonSerializer<Double> {
        public void serialize(Double value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            BigDecimal d = new BigDecimal(value.toString());
            gen.writeNumber(d.stripTrailingZeros().toPlainString());
        }

        public Class<Double> handledType() {
            return Double.class;
        }
    }
}

