/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.List;
import net.renfei.unifiauth.sdk.UnifiAuthClient;
import net.renfei.unifiauth.sdk.entity.ApiResult;
import net.renfei.unifiauth.sdk.entity.DepartmentDetail;
import net.renfei.unifiauth.sdk.utils.HttpClientUtils;
import net.renfei.unifiauth.sdk.utils.JSONUtils;

public class DepartmentService {
    private final UnifiAuthClient UNIFI_AUTH_CLIENT;

    public DepartmentService(UnifiAuthClient unifiAuthClient) {
        this.UNIFI_AUTH_CLIENT = unifiAuthClient;
    }

    public List<DepartmentDetail> queryDeptTree(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/dept");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<List<DepartmentDetail>> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<List<DepartmentDetail>>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }

    public List<DepartmentDetail> queryDeptTree(String token, long id) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/dept/").append(id).append("child");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<List<DepartmentDetail>> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<List<DepartmentDetail>>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }
}

