/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.List;
import net.renfei.unifiauth.sdk.UnifiAuthClient;
import net.renfei.unifiauth.sdk.entity.ApiResult;
import net.renfei.unifiauth.sdk.entity.MenuDetail;
import net.renfei.unifiauth.sdk.entity.RoleDetail;
import net.renfei.unifiauth.sdk.entity.UserProfile;
import net.renfei.unifiauth.sdk.utils.HttpClientUtils;
import net.renfei.unifiauth.sdk.utils.JSONUtils;

public class UserService {
    private final UnifiAuthClient UNIFI_AUTH_CLIENT;

    public UserService(UnifiAuthClient unifiAuthClient) {
        this.UNIFI_AUTH_CLIENT = unifiAuthClient;
    }

    public UserProfile queryUserProfile(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/profile");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<UserProfile> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<UserProfile>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }

    public List<RoleDetail> queryUserRoleList(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/roles");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<List<RoleDetail>> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<List<RoleDetail>>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }

    public List<MenuDetail> queryUserMenuTree(String token) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_CLIENT.UNIFI_AUTH_SERVER_URI.endsWith("/")) {
            url.append("/");
        }
        url.append("resource/menus");
        URI uri = new URI(url.toString());
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.get(uri, token);
        ApiResult<List<MenuDetail>> apiResult = JSONUtils.json2pojo(result, new TypeReference<ApiResult<List<MenuDetail>>>(){});
        if (apiResult.getCode() == 200) {
            return apiResult.getData();
        }
        throw new RuntimeException(apiResult.getMessage());
    }
}

