/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.renfei.unifiauth.sdk.entity.AccessTokenDataObject;
import net.renfei.unifiauth.sdk.entity.CallbackDataObject;
import net.renfei.unifiauth.sdk.service.UserService;
import net.renfei.unifiauth.sdk.utils.HttpClientUtils;
import net.renfei.unifiauth.sdk.utils.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public final class UnifiAuthClient {
    public static final String URI_SEPARATOR = "/";
    public static final String RESPONSE_TYPE = "?response_type=code";
    public final String UNIFI_AUTH_SERVER_URI;
    public final String CLIENT_ID;
    public final String CLIENT_SECRET;
    public final String REDIRECT_URI;

    private UnifiAuthClient() {
        throw new RuntimeException("Prohibit direct instantiation.");
    }

    public UnifiAuthClient(String unifiAuthServerUri, String clientId, String clientSecret, String redirectUri) {
        this.UNIFI_AUTH_SERVER_URI = unifiAuthServerUri;
        this.CLIENT_ID = clientId;
        this.CLIENT_SECRET = clientSecret;
        this.REDIRECT_URI = redirectUri;
    }

    public String generateAuthorizeRequestUrl(Set<String> scopes, String state) {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_SERVER_URI.endsWith(URI_SEPARATOR)) {
            url.append(URI_SEPARATOR);
        }
        url.append("oauth2/authorize?response_type=code&client_id=").append(this.CLIENT_ID).append("&redirect_uri=").append(this.REDIRECT_URI);
        if (scopes != null && !scopes.isEmpty()) {
            url.append("&scope=");
            for (String scope : scopes) {
                url.append(scope).append(" ");
            }
            url.delete(url.length() - 1, url.length());
        }
        if (state != null && state.length() > 0) {
            url.append("&state=").append(state);
        }
        return url.toString();
    }

    public CallbackDataObject handlingCallback(HttpServletRequest request) {
        return this.convertCallbackDataObject(request.getParameterMap());
    }

    public CallbackDataObject convertCallbackDataObject(Map<String, String[]> params) {
        CallbackDataObject callbackDataObject = new CallbackDataObject();
        callbackDataObject.setSuccess(false);
        for (Map.Entry<String, String[]> param : params.entrySet()) {
            switch (param.getKey()) {
                case "code": {
                    callbackDataObject.setCode(StringUtils.join((Object[])param.getValue()));
                    callbackDataObject.setSuccess(true);
                    break;
                }
                case "state": {
                    callbackDataObject.setState(StringUtils.join((Object[])param.getValue()));
                    break;
                }
                case "error": {
                    callbackDataObject.setError(StringUtils.join((Object[])param.getValue()));
                    break;
                }
                case "error_description": {
                    callbackDataObject.setErrorDescription(StringUtils.join((Object[])param.getValue()));
                    break;
                }
                case "error_uri": {
                    callbackDataObject.setErrorUri(StringUtils.join((Object[])param.getValue()));
                    break;
                }
            }
        }
        return callbackDataObject;
    }

    public AccessTokenDataObject exchangeToken(final String code) throws Exception {
        StringBuilder url = new StringBuilder(this.UNIFI_AUTH_SERVER_URI);
        if (!this.UNIFI_AUTH_SERVER_URI.endsWith(URI_SEPARATOR)) {
            url.append(URI_SEPARATOR);
        }
        url.append("oauth2/token");
        URI uri = new URI(url.toString());
        HashMap<String, String> data = new HashMap<String, String>(){
            {
                this.put("grant_type", "authorization_code");
                this.put("client_id", UnifiAuthClient.this.CLIENT_ID);
                this.put("redirect_uri", UnifiAuthClient.this.REDIRECT_URI);
                this.put("code", code);
            }
        };
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        String result = httpClientUtils.postForm(uri, this.CLIENT_ID, this.CLIENT_SECRET, (Map<String, String>)data);
        Map<String, Object> stringObjectMap = JSONUtils.json2map(result);
        if (stringObjectMap.get("access_token") != null) {
            return JSONUtils.json2pojo(result, AccessTokenDataObject.class);
        }
        if (stringObjectMap.get("error") != null) {
            throw new RuntimeException(stringObjectMap.get("error").toString());
        }
        if (stringObjectMap.get("message") != null) {
            throw new RuntimeException(stringObjectMap.get("message").toString());
        }
        throw new RuntimeException("RuntimeException: result: " + result);
    }

    public UserService user() {
        return new UserService(this);
    }
}

