/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.unifiauth.sdk.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EncryptionUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String encrypt(String algorithm, String body) {
        if (algorithm == null || body == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(body.getBytes());
            return EncryptionUtils.getFormattedText(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (byte aByte : bytes) {
            buf.append(HEX_DIGITS[aByte >> 4 & 0xF]);
            buf.append(HEX_DIGITS[aByte & 0xF]);
        }
        return buf.toString();
    }
}

