/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.philisense.sso.sdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import net.renfei.philisense.sso.sdk.SingleSignOnException;
import net.renfei.philisense.sso.sdk.model.Oauth2Token;
import net.renfei.philisense.sso.sdk.model.Oauth2UserInfo;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleSignOn {
    private static final Logger logger = LoggerFactory.getLogger(SingleSignOn.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String OAUTH2_LOGIN_ENDPOINT = "http://oauth-api.philisensedev.com/site/login?redirect_url=/oauth2/authorize";
    public static final String OAUTH2_TOKEN_ENDPOINT = "http://oauth-api.philisensedev.com/oauth2/token";
    public static final String OAUTH2_USERINFO_ENDPOINT = "http://oauth-api.philisensedev.com/oauth/userinfo";
    public static final String GRANT_TYPE_CODE = "authorization_code";
    public static final String GRANT_TYPE_REFRESH = "refresh_token";
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private String state;
    private final RequestConfig requestConfig;

    private SingleSignOn() {
        this.requestConfig = RequestConfig.DEFAULT;
    }

    public SingleSignOn(String clientId, String clientSecret, String redirectUri, String state) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.state = state;
        this.requestConfig = RequestConfig.DEFAULT;
    }

    public String getLogInUrl() {
        return "http://oauth-api.philisensedev.com/site/login?redirect_url=/oauth2/authorize?client_id=" + this.clientId + "&redirect_uri=" + this.redirectUri + "&response_type=code&state=" + this.state;
    }

    public Oauth2Token getToken(String code) throws IOException, ParseException, SingleSignOnException {
        Throwable throwable = null;
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(OAUTH2_TOKEN_ENDPOINT);
            httpPost.setConfig(this.requestConfig);
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", GRANT_TYPE_CODE));
            parameters.add(new BasicNameValuePair("code", code));
            parameters.add(new BasicNameValuePair("client_id", this.clientId));
            parameters.add(new BasicNameValuePair("client_secret", this.clientSecret));
            parameters.add(new BasicNameValuePair("redirect_uri", this.redirectUri));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getCode() == 200) {
                logger.info(responseString);
                Oauth2Token oauth2Token = SingleSignOn.string2Obj(responseString, Oauth2Token.class);
                return oauth2Token;
            }
            try {
                logger.error(responseString);
                throw new SingleSignOnException(responseString);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Oauth2UserInfo getUserInfo(String accessToken) throws IOException, ParseException, SingleSignOnException {
        Throwable throwable = null;
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet("http://oauth-api.philisensedev.com/oauth/userinfo?access_token=" + accessToken);
            httpGet.setConfig(this.requestConfig);
            CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpGet);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getCode() == 200) {
                logger.info(responseString);
                Oauth2UserInfo oauth2UserInfo = SingleSignOn.string2Obj(responseString, Oauth2UserInfo.class);
                return oauth2UserInfo;
            }
            try {
                logger.error(responseString);
                throw new SingleSignOnException(responseString);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static <T> T string2Obj(String str, Class<T> clazz) {
        if (str == null || str.length() < 1 || clazz == null) {
            return null;
        }
        try {
            return (T)(clazz.equals(String.class) ? str : OBJECT_MAPPER.readValue(str, clazz));
        }
        catch (Exception e) {
            logger.warn("Parse String to Object error : {}", (Object)e.getMessage());
            return null;
        }
    }
}

