/*
 * Decompiled with CFR 0.152.
 */
package net.reevik.darkest.validators;

import java.time.Duration;
import net.reevik.darkest.Result;
import net.reevik.darkest.validators.ResultValidator;
import net.reevik.darkest.validators.ValidationResult;
import net.reevik.darkest.validators.ValidatorFactory;

public class PerformanceAcceptanceImpl<T>
implements ResultValidator<T> {
    private final Duration maxDeviance;

    public PerformanceAcceptanceImpl(Duration maxDeviance) {
        this.maxDeviance = maxDeviance;
    }

    @Override
    public ValidationResult validate(Result<T> resultASide, Result<T> resultBSide) {
        Duration diffDuration = resultBSide.getDuration().minus(resultASide.getDuration());
        return ValidatorFactory.newResult(diffDuration.compareTo(this.maxDeviance) > 0, String.format("Performance check failed: The response time of the B Side deviates by %d seconds.", diffDuration.getSeconds()));
    }
}

