/*
 * Decompiled with CFR 0.152.
 */
package net.reevik.darkest;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.reevik.darkest.Monitorable;
import net.reevik.darkest.NoopMonitoringImpl;
import net.reevik.darkest.RoutingMode;
import net.reevik.darkest.SideCommand;
import net.reevik.darkest.criteria.RoutingCondition;
import net.reevik.darkest.validators.ResultValidator;

public class RoutingConfiguration<T> {
    private final SideCommand<T> sideACommand;
    private final SideCommand<T> sideBCommand;
    private final ExecutorService executorService;
    private final ResultValidator<T> validator;
    private final RoutingMode routingMode;
    private final RoutingCondition routingCondition;
    private final Monitorable monitorable;

    public RoutingConfiguration(SideCommand<T> sideACommand, SideCommand<T> sideBCommand, ResultValidator<T> validator, RoutingMode routingMode, RoutingCondition routingCondition, Monitorable monitorable) {
        this.sideACommand = sideACommand;
        this.sideBCommand = sideBCommand;
        this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        this.validator = validator;
        this.routingMode = routingMode;
        this.routingCondition = routingCondition;
        this.monitorable = monitorable;
    }

    public SideCommand<T> getSideACommand() {
        return this.sideACommand;
    }

    public SideCommand<T> getSideBCommand() {
        return this.sideBCommand;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ResultValidator<T> getValidator() {
        return this.validator;
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public RoutingCondition getRoutingCriterion() {
        return this.routingCondition;
    }

    public Monitorable getMonitorable() {
        return this.monitorable;
    }

    static class Builder<T> {
        private SideCommand<T> sideACommand;
        private SideCommand<T> sideBCommand;
        private ResultValidator<T> validator;
        private RoutingMode routingMode;
        private RoutingCondition routingCondition;
        private Monitorable monitorable = new NoopMonitoringImpl();

        Builder() {
        }

        public static <T> Builder<T> create() {
            return new Builder<T>();
        }

        public Builder<T> withSideA(Callable<T> callable) {
            this.sideACommand = new SideCommand<T>(callable);
            return this;
        }

        public Builder<T> withSideB(Callable<T> callable) {
            this.sideBCommand = new SideCommand<T>(callable);
            return this;
        }

        public Builder<T> withResultValidator(ResultValidator<T> validator) {
            this.validator = validator;
            return this;
        }

        public Builder<T> withRoutingMode(RoutingMode routingMode) {
            this.routingMode = routingMode;
            return this;
        }

        public Builder<T> withRoutingCriterion(RoutingCondition routingCriterion) {
            this.routingCondition = routingCriterion;
            return this;
        }

        public Builder<T> withMonitorable(Monitorable monitorable) {
            this.monitorable = monitorable;
            return this;
        }

        public RoutingConfiguration<T> build() {
            return new RoutingConfiguration<T>(this.sideACommand, this.sideBCommand, this.validator, this.routingMode, this.routingCondition, this.monitorable);
        }
    }
}

