/*
 * Decompiled with CFR 0.152.
 */
package net.reevik.darkest;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.reevik.darkest.Monitorable;
import net.reevik.darkest.Result;
import net.reevik.darkest.RoutingConfiguration;
import net.reevik.darkest.RoutingMode;
import net.reevik.darkest.SideCommand;
import net.reevik.darkest.validators.ResultValidator;
import net.reevik.darkest.validators.ValidationResult;

public class EndpointRouter<T> {
    private final RoutingConfiguration<T> config;

    public EndpointRouter(RoutingConfiguration<T> config) {
        this.config = config;
    }

    public T route() throws Exception {
        SideCommand<T> sideBCommand = this.config.getSideBCommand();
        SideCommand<T> sideACommand = this.config.getSideACommand();
        return (switch (this.config.getRoutingMode()) {
            case RoutingMode.B_SIDE -> sideBCommand.run();
            case RoutingMode.ROLL_OUT -> this.rollOut(sideBCommand, sideACommand);
            case RoutingMode.SHADOW_MODE_ACTIVE -> this.shadowTestAndReturn(sideBCommand, sideACommand);
            case RoutingMode.SHADOW_MODE_PASSIVE -> this.shadowTest(sideBCommand, sideACommand);
            default -> sideACommand.run();
        }).getOrThrow();
    }

    private Result<T> shadowTestAndReturn(SideCommand<T> sideBCommand, SideCommand<T> sideACommand) throws InterruptedException, ExecutionException {
        Result<T> resultA = sideACommand.run();
        Future<Result<T>> result = this.getResult(sideBCommand, resultA);
        return result.get();
    }

    private Future<Result<T>> getResult(SideCommand<T> sideBCommand, Result<T> resultA) {
        ResultValidator validator = this.config.getValidator();
        Monitorable monitorable = this.config.getMonitorable();
        return this.config.getExecutorService().submit(() -> {
            Result resultB = sideBCommand.run();
            ValidationResult validationResult = validator.validate(resultA, resultB);
            if (validationResult.isPassed()) {
                monitorable.onRoute();
                return resultB;
            }
            monitorable.onValidationError(validationResult);
            return resultA;
        });
    }

    private Result<T> shadowTest(SideCommand<T> sideBCommand, SideCommand<T> sideACommand) {
        Result<T> resultA = sideACommand.run();
        this.getResult(sideBCommand, sideACommand.run());
        return resultA;
    }

    private Result<T> rollOut(SideCommand<T> sideBCommand, SideCommand<T> sideACommand) {
        if (this.canRoute()) {
            return sideBCommand.run();
        }
        return sideACommand.run();
    }

    private boolean canRoute() {
        return this.config.getRoutingCriterion().canRoute();
    }
}

