/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.template;

import io.reactivex.Single;
import io.vertx.reactivex.core.file.FileSystem;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import net.redpipe.engine.core.AppGlobals;
import net.redpipe.engine.template.AbstractTemplate;
import net.redpipe.engine.template.TemplateRenderer;
import net.redpipe.engine.util.RedpipeUtil;

public class Template
extends AbstractTemplate {
    public Template(String name, Map<String, Object> variables) {
        super(name, variables);
    }

    public Template(String name) {
        super(name);
    }

    public Template() {
    }

    @Override
    public Template set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    public Single<Response> render(Request request) {
        return this.selectVariant(request).flatMap(template -> {
            TemplateRenderer renderer = AppGlobals.get().getTemplateRenderer((String)template);
            if (renderer == null) {
                throw new RuntimeException("Failed to find template renderer for template " + template);
            }
            return renderer.render((String)template, this.variables);
        }).onErrorReturn(t -> {
            if (t instanceof WebApplicationException) {
                return ((WebApplicationException)t).getResponse();
            }
            return (Response)RedpipeUtil.rethrow(t);
        });
    }

    public Single<String> selectVariant(Request request) {
        return this.loadVariants().flatMap(variants -> {
            if (variants.variants.isEmpty()) {
                return Single.just((Object)variants.defaultTemplate);
            }
            Variant selectedVariant = request.selectVariant(new ArrayList<Variant>(variants.variants.keySet()));
            if (selectedVariant == null) {
                String template = variants.defaultTemplate;
                FileSystem fs = AppGlobals.get().getVertx().fileSystem();
                return fs.rxExists(template).map(exists -> {
                    if (exists.booleanValue()) {
                        return template;
                    }
                    throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
                });
            }
            return Single.just((Object)variants.variants.get(selectedVariant));
        });
    }
}

