/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.template;

import io.reactivex.Single;
import io.vertx.reactivex.core.file.FileSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractTemplate {
    protected final Map<String, Object> variables;
    protected final String name;

    public AbstractTemplate(String name, Map<String, Object> variables) {
        this.name = name;
        this.variables = variables;
    }

    public AbstractTemplate(String name) {
        this(name, new HashMap<String, Object>());
    }

    public AbstractTemplate() {
        this(AbstractTemplate.getActionName());
    }

    private static String getActionName() {
        ResourceInfo resourceMethod = (ResourceInfo)ResteasyProviderFactory.getContextData(ResourceInfo.class);
        return "templates/" + resourceMethod.getResourceClass().getSimpleName() + "/" + resourceMethod.getResourceMethod().getName();
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getName() {
        return this.name;
    }

    public AbstractTemplate set(String name, Object value) {
        this.variables.put(name, value);
        return this;
    }

    protected Single<TemplateVariants> loadVariants() {
        String namePart;
        String templateDir;
        String path = this.name;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            templateDir = path.substring(0, lastSlash);
            namePart = path.substring(lastSlash + 1);
        } else {
            templateDir = "";
            namePart = path;
        }
        FileSystem fs = AppGlobals.get().getVertx().fileSystem();
        return fs.rxReadDir(templateDir).map(list -> this.loadVariants(fs, templateDir, namePart, (List<String>)list));
    }

    private TemplateVariants loadVariants(FileSystem fs, String templateDir, String namePart, List<String> list) {
        HashMap<Variant, String> variants = new HashMap<Variant, String>();
        String defaultTemplateExtension = "";
        for (String entry : list) {
            String extensionWithDot;
            int lastSlash = entry.lastIndexOf(47);
            if (lastSlash != -1) {
                entry = entry.substring(lastSlash + 1);
            }
            if (entry.equals(namePart) || !entry.startsWith(namePart) || !(extensionWithDot = entry.substring(namePart.length())).startsWith(".")) continue;
            int templateExtension = extensionWithDot.indexOf(46, 1);
            if (templateExtension == -1) {
                defaultTemplateExtension = extensionWithDot;
                continue;
            }
            String mediaExtension = extensionWithDot.substring(1, templateExtension);
            MediaType mediaType = AbstractTemplate.parseMediaType(mediaExtension);
            variants.put(new Variant(mediaType, (String)null, null), templateDir + "/" + entry);
        }
        return new TemplateVariants(templateDir + "/" + namePart + defaultTemplateExtension, variants);
    }

    public static MediaType parseMediaType(String extension) {
        if (extension.equalsIgnoreCase("html")) {
            return MediaType.TEXT_HTML_TYPE;
        }
        if (extension.equalsIgnoreCase("xml")) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        if (extension.equalsIgnoreCase("txt")) {
            return MediaType.TEXT_PLAIN_TYPE;
        }
        if (extension.equalsIgnoreCase("json")) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        System.err.println("Unknown extension type: " + extension);
        return MediaType.APPLICATION_OCTET_STREAM_TYPE;
    }

    public static MediaType parseMediaType(String templatePath, String templateExtension) {
        int lastDot;
        int lastSlash = templatePath.lastIndexOf(47);
        String templateName = lastSlash != -1 ? templatePath.substring(lastSlash + 1) : templatePath;
        if (templateName.endsWith(templateExtension)) {
            templateName = templateName.substring(0, templateName.length() - templateExtension.length());
        }
        if ((lastDot = templateName.lastIndexOf(46)) != -1) {
            return AbstractTemplate.parseMediaType(templateName.substring(lastDot + 1));
        }
        return MediaType.APPLICATION_OCTET_STREAM_TYPE;
    }

    public class TemplateVariants {
        public final Map<Variant, String> variants;
        public final String defaultTemplate;

        public TemplateVariants(String defaultTemplate, Map<Variant, String> variants) {
            this.defaultTemplate = defaultTemplate;
            this.variants = variants;
        }

        public String getVariantTemplate(MediaType mediaType) {
            return this.getVariantTemplate(mediaType, this.defaultTemplate);
        }

        public String getVariantTemplate(MediaType mediaType, String templateIfVariantNotFound) {
            Variant variant = new Variant(mediaType, (String)null, null);
            if (this.variants.containsKey(variant)) {
                return this.variants.get(variant);
            }
            return templateIfVariantNotFound;
        }
    }
}

