/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.security;

import io.reactivex.Single;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.auth.AuthProvider;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.Session;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.redpipe.engine.core.AppGlobals;

@Path(value="/")
public abstract class BaseSecurityResource {
    public static final String REDIRECT_KEY = "__login_redirect";

    @GET
    @Path(value="/login")
    public abstract Object login(@Context UriInfo var1);

    @POST
    @Path(value="/loginAuth")
    public Single<Response> loginAuth(@FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="return_url") String returnUrl, @Context Session session, @Context RoutingContext ctx, @Context AuthProvider auth) throws URISyntaxException {
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            return Single.just((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        JsonObject authInfo = new JsonObject().put("username", username).put("password", password);
        return auth.rxAuthenticate(authInfo).map(user -> {
            String redirectUrl;
            ctx.setUser(user);
            if (session != null) {
                session.regenerateId();
            }
            if ((redirectUrl = (String)session.remove(REDIRECT_KEY)) == null) {
                redirectUrl = returnUrl;
            }
            if (redirectUrl == null) {
                redirectUrl = "/";
            }
            try {
                return Response.status((Response.Status)Response.Status.FOUND).location(new URI(redirectUrl)).build();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).onErrorReturn(t -> Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)t.getMessage()).type("text/plain").build());
    }

    @GET
    @Path(value="/logout")
    public Response logout(@Context UriInfo uriInfo, @Context RoutingContext ctx, @Context AppGlobals globals) {
        ctx.clearUser();
        UriBuilder builder = uriInfo.getBaseUriBuilder();
        URI rootUri = builder.path(globals.getMainClass()).build(new Object[0]);
        return Response.status((Response.Status)Response.Status.FOUND).location(rootUri).build();
    }
}

