/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.security;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import net.redpipe.engine.security.AuthorizationFilter;
import net.redpipe.engine.security.LoginRedirectFilter;
import net.redpipe.engine.security.NoAuthFilter;
import net.redpipe.engine.security.NoAuthRedirect;
import net.redpipe.engine.security.RequiresPermissions;
import net.redpipe.engine.security.RequiresUser;

@Provider
public class AuthorizationFilterFeature
implements DynamicFeature {
    private static List<Class<? extends Annotation>> filterAnnotations = Collections.unmodifiableList(Arrays.asList(RequiresPermissions.class, RequiresUser.class));

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ArrayList<Annotation> authzSpecs = new ArrayList<Annotation>();
        boolean canRedirect = true;
        for (Class<? extends Annotation> annotationClass : filterAnnotations) {
            Annotation classAuthzSpec = resourceInfo.getResourceClass().getAnnotation(annotationClass);
            Annotation methodAuthzSpec = resourceInfo.getResourceMethod().getAnnotation(annotationClass);
            if (classAuthzSpec != null) {
                authzSpecs.add(classAuthzSpec);
            }
            if (methodAuthzSpec != null) {
                authzSpecs.add(methodAuthzSpec);
            }
            if (resourceInfo.getResourceClass().isAnnotationPresent(NoAuthRedirect.class) || resourceInfo.getResourceMethod().isAnnotationPresent(NoAuthRedirect.class)) {
                canRedirect = false;
            }
            if (!resourceInfo.getResourceClass().isAnnotationPresent(NoAuthFilter.class) && !resourceInfo.getResourceMethod().isAnnotationPresent(NoAuthFilter.class)) continue;
            return;
        }
        if (!authzSpecs.isEmpty()) {
            if (canRedirect) {
                context.register((Object)new LoginRedirectFilter(), 1001);
            }
            context.register((Object)new AuthorizationFilter(authzSpecs), 2000);
        }
    }
}

