/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.mail;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.ext.mail.MailClient;
import java.util.Arrays;
import java.util.Optional;
import net.redpipe.engine.mail.Mail;
import net.redpipe.engine.mail.Mailer;

public class ProdMailer
implements Mailer {
    private MailClient mailClient;

    public ProdMailer(Vertx vertx, JsonObject serverConfig) {
        MailConfig config = new MailConfig();
        config.setHostname(serverConfig.getString("smtp.hostname", "localhost"));
        config.setPort(serverConfig.getInteger("smtp.port", Integer.valueOf(25)).intValue());
        config.setUsername(serverConfig.getString("smtp.username"));
        config.setPassword(serverConfig.getString("smtp.password"));
        config.setKeepAlive(serverConfig.getBoolean("smtp.keepAlive", Boolean.valueOf(true)).booleanValue());
        config.setTrustAll(serverConfig.getBoolean("smtp.trustAll", Boolean.valueOf(true)).booleanValue());
        config.setStarttls(StartTLSOptions.valueOf((String)serverConfig.getString("smtp.starttls", MailConfig.DEFAULT_TLS.name())));
        this.mailClient = MailClient.createShared((Vertx)vertx, (MailConfig)config);
    }

    @Override
    public Completable send(Mail email) {
        Single htmlRender = email.renderHtml().map(buffer -> Optional.of(buffer)).toSingle(Optional.empty());
        Single<Buffer> textRender = email.renderText();
        return Single.zip(textRender, (SingleSource)htmlRender, (text, html) -> {
            MailMessage message = new MailMessage();
            message.setFrom(email.from);
            if (email.to != null) {
                message.setTo(Arrays.asList(email.to));
            }
            if (email.cc != null) {
                message.setCc(Arrays.asList(email.cc));
            }
            if (email.bcc != null) {
                message.setBcc(Arrays.asList(email.bcc));
            }
            message.setSubject(email.subject);
            message.setText(text.toString());
            if (html.isPresent()) {
                message.setHtml(((Buffer)html.get()).toString());
            }
            return this.mailClient.rxSendMail(message).ignoreElement();
        }).flatMapCompletable(c -> c);
    }
}

