/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.dispatcher;

import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.Handler;
import io.vertx.reactivex.core.Context;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.HttpServerResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.redpipe.engine.core.AppGlobals;
import net.redpipe.engine.dispatcher.PluginRequestDispatcher;
import net.redpipe.engine.dispatcher.VertxHttpResponseWithWorkaround;
import net.redpipe.engine.spi.Plugin;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.vertx.RequestDispatcher;
import org.jboss.resteasy.plugins.server.vertx.VertxHttpRequest;
import org.jboss.resteasy.plugins.server.vertx.VertxHttpResponse;
import org.jboss.resteasy.plugins.server.vertx.VertxUtil;
import org.jboss.resteasy.plugins.server.vertx.i18n.LogMessages;
import org.jboss.resteasy.plugins.server.vertx.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public class VertxPluginRequestHandler
implements Handler<HttpServerRequest> {
    private final Vertx vertx;
    protected final RequestDispatcher dispatcher;
    private final String servletMappingPrefix;
    private AppGlobals appGlobals;

    public VertxPluginRequestHandler(Vertx vertx, ResteasyDeployment deployment, String servletMappingPrefix, SecurityDomain domain, List<Plugin> plugins) {
        this.vertx = vertx;
        this.dispatcher = new PluginRequestDispatcher((SynchronousDispatcher)deployment.getDispatcher(), deployment.getProviderFactory(), domain, plugins);
        this.servletMappingPrefix = servletMappingPrefix;
        this.appGlobals = AppGlobals.get();
    }

    public VertxPluginRequestHandler(Vertx vertx, ResteasyDeployment deployment, String servletMappingPrefix, List<Plugin> plugins) {
        this(vertx, deployment, servletMappingPrefix, null, plugins);
    }

    public VertxPluginRequestHandler(Vertx vertx, ResteasyDeployment deployment, List<Plugin> plugins) {
        this(vertx, deployment, "", plugins);
    }

    public void handle(HttpServerRequest request) {
        request.bodyHandler(buff -> {
            Context ctx = this.vertx.getOrCreateContext();
            ResteasyUriInfo uriInfo = VertxUtil.extractUriInfo((io.vertx.core.http.HttpServerRequest)request.getDelegate(), (String)this.servletMappingPrefix);
            ResteasyHttpHeaders headers = VertxUtil.extractHttpHeaders((io.vertx.core.http.HttpServerRequest)request.getDelegate());
            HttpServerResponse response = request.response();
            VertxHttpResponseWithWorkaround vertxResponse = new VertxHttpResponseWithWorkaround(response.getDelegate(), this.dispatcher.getProviderFactory(), request.method());
            VertxHttpRequest vertxRequest = new VertxHttpRequest(ctx.getDelegate(), headers, uriInfo, request.rawMethod(), this.dispatcher.getDispatcher(), (VertxHttpResponse)vertxResponse, false);
            if (buff.length() > 0) {
                ByteBufInputStream in = new ByteBufInputStream(buff.getDelegate().getByteBuf());
                vertxRequest.setInputStream((InputStream)in);
            }
            try {
                AppGlobals.set(this.appGlobals);
                this.appGlobals.injectGlobals();
                this.dispatcher.service(ctx.getDelegate(), request.getDelegate(), response.getDelegate(), (HttpRequest)vertxRequest, (HttpResponse)vertxResponse, true);
            }
            catch (Failure e1) {
                vertxResponse.setStatus(e1.getErrorCode());
            }
            catch (Exception ex) {
                vertxResponse.setStatus(500);
                LogMessages.LOGGER.error((Object)Messages.MESSAGES.unexpected(), (Throwable)ex);
            }
            finally {
                AppGlobals.set(null);
            }
            if (!vertxRequest.getAsyncContext().isSuspended()) {
                try {
                    vertxResponse.finish();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

