/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.dispatcher;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.server.vertx.VertxHttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class VertxHttpResponseWithWorkaround
extends VertxHttpResponse {
    private HttpServerResponse response;

    public VertxHttpResponseWithWorkaround(HttpServerResponse response, ResteasyProviderFactory providerFactory) {
        super(response, providerFactory);
        this.response = response;
    }

    public VertxHttpResponseWithWorkaround(HttpServerResponse response, ResteasyProviderFactory providerFactory, HttpMethod method) {
        super(response, providerFactory, method);
        this.response = response;
    }

    public void prepareChunkStream() {
        super.prepareChunkStream();
        if (this.isWithoutBody()) {
            this.response.setChunked(false);
            this.response.headersEndHandler(h -> {
                this.response.headers().remove(HttpHeaders.CONTENT_LENGTH);
                this.response.headers().remove(HttpHeaders.CONTENT_TYPE);
            });
        }
    }

    private boolean isWithoutBody() {
        int status = this.response.getStatusCode();
        return status >= 100 && status < 200 || status == Response.Status.NO_CONTENT.getStatusCode() || status == Response.Status.NOT_MODIFIED.getStatusCode();
    }
}

