/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.core;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.reactiverse.reactivecontexts.core.Context;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.config.ReaderConfigUtils;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.reactivex.config.ConfigRetriever;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.jdbc.JDBCClient;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.handler.CookieHandler;
import io.vertx.reactivex.ext.web.handler.SessionHandler;
import io.vertx.reactivex.ext.web.sstore.LocalSessionStore;
import io.vertx.reactivex.ext.web.sstore.SessionStore;
import io.vertx.rxjava.ext.auth.AuthProvider;
import io.vertx.rxjava.ext.web.Session;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import net.redpipe.engine.core.AppGlobals;
import net.redpipe.engine.core.MainResource;
import net.redpipe.engine.core.MyBeanConfig;
import net.redpipe.engine.dispatcher.VertxPluginRequestHandler;
import net.redpipe.engine.resteasy.RedpipeServletContext;
import net.redpipe.engine.spi.Plugin;
import net.redpipe.engine.swagger.RxModelConverter;
import net.redpipe.engine.template.TemplateRenderer;
import net.redpipe.engine.util.RedpipeUtil;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class Server {
    private Vertx vertx;
    protected List<Plugin> plugins;
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    protected String configFile = "conf/config.json";
    private AppGlobals appGlobals;

    public Completable start() {
        return this.start((JsonObject)null, new Class[0]);
    }

    public Completable start(Class<?> ... resourceOrProviderClasses) {
        return this.start((JsonObject)null, resourceOrProviderClasses);
    }

    public Completable start(JsonObject defaultConfig, Class<?> ... resourceOrProviderClasses) {
        AppGlobals.clear();
        this.appGlobals = AppGlobals.init();
        return Single.create(s -> {
            this.setupLogging();
            VertxOptions options = new VertxOptions();
            options.setWarningExceptionTime(Long.MAX_VALUE);
            Context.load();
            JsonObject config = this.loadFileConfig(defaultConfig);
            AppGlobals.get().setConfig(config);
            s.onSuccess((Object)config);
        }).flatMap(this::initVertx).flatMapCompletable(vertx -> {
            this.vertx = vertx;
            AppGlobals.get().setVertx(this.vertx);
            return this.setupPlugins();
        }).concatWith((CompletableSource)this.setupTemplateRenderers()).andThen(this.setupResteasy(resourceOrProviderClasses)).flatMapCompletable(deployment -> {
            this.setupSwagger((VertxResteasyDeployment)deployment);
            return this.setupVertx((VertxResteasyDeployment)deployment);
        });
    }

    private Single<Vertx> initVertx(JsonObject config) {
        VertxOptions options = config != null ? new VertxOptions(config) : new VertxOptions();
        options.setWarningExceptionTime(Long.MAX_VALUE);
        if (options.isClustered()) {
            return Vertx.rxClusteredVertx((VertxOptions)options);
        }
        this.vertx = Vertx.vertx((VertxOptions)options);
        return Single.just((Object)this.vertx);
    }

    private Completable setupPlugins() {
        return Completable.defer(() -> {
            this.loadPlugins();
            return this.doOnPlugins(plugin -> plugin.preInit());
        });
    }

    protected void loadPlugins() {
        this.plugins = new ArrayList<Plugin>();
        for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
            this.plugins.add(plugin);
        }
    }

    private Completable setupTemplateRenderers() {
        return Completable.defer(() -> {
            ArrayList<TemplateRenderer> renderers = new ArrayList<TemplateRenderer>();
            for (TemplateRenderer renderer : ServiceLoader.load(TemplateRenderer.class)) {
                renderers.add(renderer);
            }
            AppGlobals.get().setTemplateRenderers(renderers);
            return Completable.complete();
        });
    }

    private Completable setupVertx(VertxResteasyDeployment deployment) {
        return Completable.defer(() -> {
            SQLClient dbClient = this.createDbClient(AppGlobals.get().getConfig());
            Class mainClass = null;
            for (Class resourceClass : deployment.getActualResourceClasses()) {
                if (resourceClass.getAnnotation(MainResource.class) == null) continue;
                mainClass = resourceClass;
                break;
            }
            AppGlobals globals = AppGlobals.get();
            globals.setDbClient(dbClient);
            globals.setMainClass(mainClass);
            globals.setDeployment(deployment);
            return this.doOnPlugins(plugin -> plugin.init()).concatWith((CompletableSource)this.startVertx(deployment));
        });
    }

    protected SQLClient createDbClient(JsonObject config) {
        return JDBCClient.createNonShared((Vertx)this.vertx, (JsonObject)new JsonObject().put("url", config.getString("db_url", "jdbc:hsqldb:file:db/wiki")).put("driver_class", config.getString("db_driver", "org.hsqldb.jdbcDriver")).put("max_pool_size", config.getInteger("db_max_pool_size", Integer.valueOf(30))));
    }

    private Completable doOnPlugins(Function<Plugin, Completable> operation) {
        return Completable.defer(() -> {
            Completable last = Completable.complete();
            for (Plugin plugin : this.plugins) {
                last = last.concatWith((CompletableSource)operation.apply(plugin));
            }
            return last;
        });
    }

    private Completable startVertx(VertxResteasyDeployment deployment) {
        return Completable.defer(() -> {
            Router router = Router.router((Vertx)this.vertx);
            AppGlobals globals = AppGlobals.get();
            globals.setRouter(router);
            VertxPluginRequestHandler resteasyHandler = new VertxPluginRequestHandler(this.vertx, (ResteasyDeployment)deployment, this.plugins);
            return this.doOnPlugins(plugin -> plugin.preRoute()).doOnComplete(() -> {
                this.setupRoutes(router);
                router.route().handler(routingContext -> {
                    ResteasyProviderFactory.pushContext(io.vertx.reactivex.ext.web.RoutingContext.class, (Object)routingContext);
                    ResteasyProviderFactory.pushContext(io.vertx.rxjava.ext.web.RoutingContext.class, (Object)io.vertx.rxjava.ext.web.RoutingContext.newInstance((RoutingContext)routingContext.getDelegate()));
                    resteasyHandler.handle(routingContext.request());
                });
            }).concatWith((CompletableSource)this.doOnPlugins(plugin -> plugin.postRoute())).concatWith((CompletableSource)Completable.defer(() -> {
                int port = globals.getConfig().getInteger("http_port", Integer.valueOf(9000));
                String host = globals.getConfig().getString("http_host", "0.0.0.0");
                return this.vertx.createHttpServer().requestHandler(arg_0 -> ((Router)router).accept(arg_0)).rxListen(port, host).doOnSuccess(server -> System.out.println("Server started on port " + server.actualPort())).doOnError(t -> t.printStackTrace()).ignoreElement();
            }));
        });
    }

    protected void setupRoutes(Router router) {
        router.route().handler((Handler)CookieHandler.create());
        router.route().handler(context -> {
            context.addHeadersEndHandler(v -> {
                String previousValue;
                int currentStatusCode;
                io.vertx.reactivex.ext.web.Session session = context.session();
                if (!(session.isDestroyed() || (currentStatusCode = context.response().getStatusCode()) >= 200 && currentStatusCode < 400 || (previousValue = (String)context.get("__REDPIPE_SAVED_COOKIE")) == null)) {
                    io.netty.handler.codec.http.cookie.Cookie nettyCookie = ClientCookieDecoder.LAX.decode(previousValue);
                    io.vertx.reactivex.ext.web.Cookie newCookie = io.vertx.reactivex.ext.web.Cookie.newInstance((Cookie)Cookie.cookie((io.netty.handler.codec.http.cookie.Cookie)nettyCookie));
                    context.addCookie(newCookie);
                }
            });
            context.next();
        });
        SessionHandler sessionHandler = SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx));
        router.route().handler((Handler)sessionHandler);
        io.vertx.reactivex.ext.auth.AuthProvider auth = this.setupAuthenticationRoutes();
        router.route().handler(context -> {
            context.addHeadersEndHandler(v -> {
                int currentStatusCode;
                io.vertx.reactivex.ext.web.Session session = context.session();
                if (!(session.isDestroyed() || (currentStatusCode = context.response().getStatusCode()) >= 200 && currentStatusCode < 400)) {
                    io.vertx.reactivex.ext.web.Cookie cookie = context.getCookie("vertx-web.session");
                    context.put("__REDPIPE_SAVED_COOKIE", (Object)cookie.encode());
                }
            });
            ResteasyProviderFactory.pushContext(io.vertx.reactivex.ext.auth.AuthProvider.class, (Object)auth);
            ResteasyProviderFactory.pushContext(User.class, (Object)context.user());
            ResteasyProviderFactory.pushContext(io.vertx.reactivex.ext.web.Session.class, (Object)context.session());
            ResteasyProviderFactory.pushContext(AuthProvider.class, auth != null ? AuthProvider.newInstance((io.vertx.ext.auth.AuthProvider)auth.getDelegate()) : null);
            ResteasyProviderFactory.pushContext(io.vertx.rxjava.ext.auth.User.class, context.user() != null ? io.vertx.rxjava.ext.auth.User.newInstance((io.vertx.ext.auth.User)context.user().getDelegate()) : null);
            ResteasyProviderFactory.pushContext(Session.class, context.session() != null ? Session.newInstance((io.vertx.ext.web.Session)context.session().getDelegate()) : null);
            context.next();
        });
    }

    protected io.vertx.reactivex.ext.auth.AuthProvider setupAuthenticationRoutes() {
        return null;
    }

    /*
     * Loose catch block
     */
    private JsonObject loadFileConfig(JsonObject config) {
        JsonObject jsonObject;
        String sconf;
        Throwable throwable;
        Scanner scanner;
        block23: {
            block24: {
                if (config != null) {
                    return config;
                }
                try {
                    File current = new File(".").getCanonicalFile();
                    System.setProperty("vertx.cwd", current.getAbsolutePath());
                }
                catch (Exception current) {
                    // empty catch block
                }
                String confArg = this.configFile;
                File file = new File(confArg);
                System.out.println(file.getAbsolutePath());
                scanner = new Scanner(new File(confArg)).useDelimiter("\\A");
                throwable = null;
                sconf = scanner.next();
                jsonObject = new JsonObject(sconf);
                if (scanner == null) break block23;
                if (throwable == null) break block24;
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block23;
            }
            scanner.close();
        }
        return jsonObject;
        {
            catch (DecodeException e) {
                JsonObject jsonObject2;
                block25: {
                    block26: {
                        log.error((Object)("Configuration file " + sconf + " does not contain a valid JSON object"));
                        jsonObject2 = new JsonObject();
                        if (scanner == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block25;
                    }
                    scanner.close();
                }
                return jsonObject2;
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (scanner != null) {
                                if (throwable != null) {
                                    try {
                                        scanner.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    scanner.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (FileNotFoundException e2) {
                        return new JsonObject();
                    }
                }
            }
        }
    }

    private Single<JsonObject> loadConfig(JsonObject config) {
        if (config != null) {
            AppGlobals.get().setConfig(config);
            return Single.just((Object)config);
        }
        String path = "conf/config.json";
        return this.vertx.fileSystem().rxExists(path).flatMap(exists -> {
            if (exists.booleanValue()) {
                ConfigStoreOptions fileStore = new ConfigStoreOptions().setType("file").setConfig(new JsonObject().put("path", path));
                ConfigRetrieverOptions configRetrieverOptions = new ConfigRetrieverOptions().addStore(fileStore);
                ConfigRetriever retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)configRetrieverOptions);
                return retriever.rxGetConfig().map(loadedConfig -> {
                    AppGlobals.get().setConfig((JsonObject)loadedConfig);
                    return loadedConfig;
                });
            }
            JsonObject emptyConfig = new JsonObject();
            AppGlobals.get().setConfig(emptyConfig);
            return Single.just((Object)emptyConfig);
        });
    }

    private void setupSwagger(VertxResteasyDeployment deployment) {
        ModelConverters.getInstance().addConverter((ModelConverter)new RxModelConverter());
        final RedpipeServletContext servletContext = new RedpipeServletContext();
        AppGlobals.get().setGlobal(ServletContext.class, servletContext);
        ServletConfig servletConfig = new ServletConfig(){

            public String getServletName() {
                return "pretend-servlet";
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String name) {
                return this.getServletContext().getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return this.getServletContext().getInitParameterNames();
            }
        };
        AppGlobals.get().setGlobal(ServletConfig.class, servletConfig);
        ReaderConfigUtils.initReaderConfig((ServletConfig)servletConfig);
        MyBeanConfig swaggerConfig = new MyBeanConfig();
        swaggerConfig.setVersion("1.0");
        swaggerConfig.setSchemes(new String[]{"http"});
        swaggerConfig.setHost("localhost:" + AppGlobals.get().getConfig().getInteger("http_port", Integer.valueOf(9000)));
        swaggerConfig.setBasePath("/");
        HashSet<String> resourcePackages = new HashSet<String>();
        for (Class klass : deployment.getActualResourceClasses()) {
            resourcePackages.add(klass.getPackage().getName());
        }
        swaggerConfig.setResourcePackage(String.join((CharSequence)",", resourcePackages));
        swaggerConfig.setServletConfig(servletConfig);
        swaggerConfig.setPrettyPrint(true);
        swaggerConfig.setScan(true);
        deployment.getRegistry().addPerInstanceResource(ApiListingResource.class);
        deployment.getProviderFactory().register(SwaggerSerializers.class);
    }

    protected Single<VertxResteasyDeployment> setupResteasy(Class<?> ... resourceOrProviderClasses) {
        return Single.defer(() -> {
            VertxResteasyDeployment deployment = new VertxResteasyDeployment();
            deployment.getDefaultContextObjects().put(Vertx.class, AppGlobals.get().getVertx());
            deployment.getDefaultContextObjects().put(AppGlobals.class, AppGlobals.get());
            return this.doOnPlugins(plugin -> plugin.deployToResteasy(deployment)).toSingle(() -> {
                for (Class klass : resourceOrProviderClasses) {
                    if (klass.isAnnotationPresent(Path.class)) {
                        deployment.getActualResourceClasses().add(klass);
                    }
                    if (!klass.isAnnotationPresent(Provider.class)) continue;
                    deployment.getActualProviderClasses().add(klass);
                }
                try {
                    deployment.start();
                }
                catch (ExceptionInInitializerError err) {
                    RedpipeUtil.rethrow(err.getCause());
                }
                return deployment;
            }).doOnError(t -> t.printStackTrace());
        });
    }

    private void setupLogging() {
    }

    public Completable close() {
        return this.doOnPlugins(plugin -> plugin.shutdown()).concatWith((CompletableSource)this.vertx.rxClose());
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public AppGlobals getAppGlobals() {
        return this.appGlobals;
    }

    public static void main(String[] args) {
        Server test = new Server();
        test.start();
    }
}

