/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.core;

import io.reactivex.Single;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.reactivex.ext.web.Router;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.redpipe.engine.core.Mode;
import net.redpipe.engine.mail.Mailer;
import net.redpipe.engine.mail.MockMailer;
import net.redpipe.engine.mail.ProdMailer;
import net.redpipe.engine.template.TemplateRenderer;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class AppGlobals {
    private static ThreadLocal<AppGlobals> global = new ThreadLocal();
    private JsonObject config;
    private SQLClient dbClient;
    private Class<?> mainClass;
    private Vertx vertx;
    private Router router;
    private List<TemplateRenderer> templateRenderers;
    private Map<String, Object> namedGlobals = new HashMap<String, Object>();
    private Map<Class<?>, Object> typedGlobals = new HashMap();
    private VertxResteasyDeployment deployment;
    private Mailer mailer;
    private Mode mode = Mode.DEV;

    static AppGlobals init() {
        AppGlobals globals = new AppGlobals();
        global.set(globals);
        return globals;
    }

    public static AppGlobals get() {
        return global.get();
    }

    public static AppGlobals set(AppGlobals globals) {
        AppGlobals old = global.get();
        global.set(globals);
        return old;
    }

    public static void clear() {
        global.remove();
    }

    public JsonObject getConfig() {
        return this.config;
    }

    void setConfig(JsonObject config) {
        this.config = config;
        this.mode = Mode.valueOf(config.getString("mode", "dev").toUpperCase());
    }

    public SQLClient getDbClient() {
        return this.dbClient;
    }

    void setDbClient(SQLClient dbClient) {
        this.dbClient = dbClient;
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    void setMainClass(Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    public Single<SQLConnection> getDbConnection() {
        return this.dbClient.rxGetConnection();
    }

    void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    void setTemplateRenderers(List<TemplateRenderer> renderers) {
        this.templateRenderers = renderers;
    }

    public TemplateRenderer getTemplateRenderer(String name) {
        for (TemplateRenderer renderer : this.templateRenderers) {
            if (!renderer.supportsTemplate(name)) continue;
            return renderer;
        }
        return null;
    }

    public void setGlobal(String key, Object value) {
        this.namedGlobals.put(key, value);
    }

    public Object getGlobal(String key) {
        return this.namedGlobals.get(key);
    }

    public <T> void setGlobal(Class<T> klass, T value) {
        this.typedGlobals.put(klass, value);
    }

    public <T> T getGlobal(Class<T> klass) {
        return (T)this.typedGlobals.get(klass);
    }

    public void injectGlobals() {
        for (Map.Entry<Class<?>, Object> entry : this.typedGlobals.entrySet()) {
            ResteasyProviderFactory.pushContext(entry.getKey(), (Object)entry.getValue());
        }
    }

    public void setDeployment(VertxResteasyDeployment deployment) {
        this.deployment = deployment;
    }

    public VertxResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public Mailer getMailer() {
        if (this.mailer == null) {
            this.mailer = this.mode == Mode.PROD ? new ProdMailer(this.vertx, this.config) : new MockMailer();
        }
        return this.mailer;
    }
}

