/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.security;

import io.reactivex.Single;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import net.redpipe.engine.security.AuthorizationException;
import net.redpipe.engine.security.AuthorizingAnnotationHandler;
import net.redpipe.engine.security.RequiresPermissions;
import net.redpipe.engine.security.RequiresUser;
import net.redpipe.engine.security.VertxPermissionAnnotationHandler;
import net.redpipe.engine.security.VertxUserAnnotationHandler;
import org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext;

public class AuthorizationFilter
implements ContainerRequestFilter {
    private final Map<AuthorizingAnnotationHandler, Annotation> authzChecks;

    public AuthorizationFilter(Collection<Annotation> authzSpecs) {
        HashMap<AuthorizingAnnotationHandler, Annotation> authChecks = new HashMap<AuthorizingAnnotationHandler, Annotation>(authzSpecs.size());
        for (Annotation authSpec : authzSpecs) {
            authChecks.put(AuthorizationFilter.createHandler(authSpec), authSpec);
        }
        this.authzChecks = Collections.unmodifiableMap(authChecks);
    }

    private static AuthorizingAnnotationHandler createHandler(Annotation annotation) {
        Class<? extends Annotation> t = annotation.annotationType();
        if (RequiresPermissions.class.equals(t)) {
            return new VertxPermissionAnnotationHandler();
        }
        if (RequiresUser.class.equals(t)) {
            return new VertxUserAnnotationHandler();
        }
        throw new IllegalArgumentException("Cannot create a handler for the unknown for annotation " + t);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Single ret = null;
        for (Map.Entry<AuthorizingAnnotationHandler, Annotation> authzCheck : this.authzChecks.entrySet()) {
            AuthorizingAnnotationHandler handler = authzCheck.getKey();
            Annotation authzSpec = authzCheck.getValue();
            Single check = handler.assertAuthorized(authzSpec);
            if (ret == null) {
                ret = check;
                continue;
            }
            ret = ret.zipWith(check, (a, b) -> a != false && b != false);
        }
        if (ret != null) {
            PreMatchContainerRequestContext context = (PreMatchContainerRequestContext)requestContext;
            context.suspend();
            ret.subscribe(result -> {
                if (result.booleanValue()) {
                    context.resume();
                } else {
                    context.resume((Throwable)new AuthorizationException("Authorization failed"));
                }
            }, error -> context.resume(error));
        }
    }
}

