/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava2;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.functions.Function;
import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ContextPropagatorOnSingleAssemblyAction
implements Function<Single, Single> {
    public Single apply(Single t) throws Exception {
        return new ContextPropagatorSingle(t);
    }

    public class ContextPropagatorSingle<T>
    extends Single<T> {
        private Single<T> source;
        private Map<Class<?>, Object> contextDataMap;
        private AppGlobals appGlobals;

        public ContextPropagatorSingle(Single<T> t) {
            this.source = t;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        protected void subscribeActual(SingleObserver<? super T> observer) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.subscribe(observer);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }
    }
}

