/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava2;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ContextPropagatorOnObservableCreateAction
implements BiFunction<Observable, Observer, Observer> {
    public Observer apply(Observable observable, Observer observer) throws Exception {
        return new ContextCapturerObservable(observable, observer);
    }

    public class ContextCapturerObservable<T>
    implements Observer<T> {
        private final Observer<T> source;
        private Map<Class<?>, Object> contextDataMap;
        private AppGlobals appGlobals;

        public ContextCapturerObservable(Observable<T> observable, Observer<T> observer) {
            this.source = observer;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        public void onComplete() {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onComplete();
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }

        public void onError(Throwable t) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onError(t);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }

        public void onNext(T v) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onNext(v);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }

        public void onSubscribe(Disposable d) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onSubscribe(d);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }
    }
}

