/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava2;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.functions.Function;
import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ContextPropagatorOnObservableAssemblyAction
implements Function<Observable, Observable> {
    public Observable apply(Observable t) throws Exception {
        return new ContextPropagatorObservable(t);
    }

    public class ContextPropagatorObservable<T>
    extends Observable<T> {
        private Observable<T> source;
        private Map<Class<?>, Object> contextDataMap;
        private AppGlobals appGlobals;

        public ContextPropagatorObservable(Observable<T> t) {
            this.source = t;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        protected void subscribeActual(Observer<? super T> observer) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.subscribe(observer);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }
    }
}

