/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava2;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.functions.Function;
import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ContextPropagatorOnMaybeAssemblyAction
implements Function<Maybe, Maybe> {
    public Maybe apply(Maybe t) throws Exception {
        return new ContextPropagatorMaybe(t);
    }

    public class ContextPropagatorMaybe<T>
    extends Maybe<T> {
        private Maybe<T> source;
        private Map<Class<?>, Object> contextDataMap;
        private AppGlobals appGlobals;

        public ContextPropagatorMaybe(Maybe<T> t) {
            this.source = t;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        protected void subscribeActual(MaybeObserver<? super T> observer) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.subscribe(observer);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }
    }
}

