/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava2;

import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ContextPropagatorOnFlowableCreateAction
implements BiFunction<Flowable, Subscriber, Subscriber> {
    public Subscriber apply(Flowable flowable, Subscriber observer) throws Exception {
        return new ContextCapturerFlowable(flowable, observer);
    }

    public class ContextCapturerFlowable<T>
    implements Subscriber<T> {
        private final Subscriber<T> source;
        private Map<Class<?>, Object> contextDataMap;
        private AppGlobals appGlobals;

        public ContextCapturerFlowable(Flowable<T> observable, Subscriber<T> observer) {
            this.source = observer;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        public void onComplete() {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onComplete();
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }

        public void onError(Throwable t) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onError(t);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }

        public void onNext(T v) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onNext(v);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }

        public void onSubscribe(Subscription s) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.onSubscribe(s);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }
    }
}

