/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava2;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.reactivestreams.Subscriber;

public class ContextPropagatorOnFlowableAssemblyAction
implements Function<Flowable, Flowable> {
    public Flowable apply(Flowable t) throws Exception {
        return new ContextPropagatorFlowable(t);
    }

    public class ContextPropagatorFlowable<T>
    extends Flowable<T> {
        private Flowable<T> source;
        private Map<Class<?>, Object> contextDataMap;
        private AppGlobals appGlobals;

        public ContextPropagatorFlowable(Flowable<T> t) {
            this.source = t;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        protected void subscribeActual(Subscriber<? super T> observer) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            AppGlobals previous = AppGlobals.set(this.appGlobals);
            try {
                this.source.subscribe(observer);
            }
            finally {
                AppGlobals.set(previous);
                ResteasyProviderFactory.removeContextDataLevel();
            }
        }
    }
}

