/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava;

import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;
import rx.functions.Func1;

public class ResteasyContextPropagatingOnSingleCreateAction
implements Func1<Single.OnSubscribe, Single.OnSubscribe> {
    public Single.OnSubscribe call(Single.OnSubscribe t) {
        return new ContextCapturerSingle(t);
    }

    static final class ContextCapturerSingle<T>
    implements Single.OnSubscribe<T> {
        final Map<Class<?>, Object> contextDataMap;
        final Single.OnSubscribe<T> source;
        private AppGlobals appGlobals;

        public ContextCapturerSingle(Single.OnSubscribe<T> source) {
            this.source = source;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        public void call(SingleSubscriber<? super T> t) {
            this.source.call(new OnAssemblySingleSubscriber<T>(t, this.contextDataMap, this.appGlobals));
        }

        static final class OnAssemblySingleSubscriber<T>
        extends SingleSubscriber<T> {
            final SingleSubscriber<? super T> actual;
            final Map<Class<?>, Object> contextDataMap;
            private AppGlobals appGlobals;

            public OnAssemblySingleSubscriber(SingleSubscriber<? super T> actual, Map<Class<?>, Object> contextDataMap, AppGlobals appGlobals) {
                this.actual = actual;
                this.contextDataMap = contextDataMap;
                this.appGlobals = appGlobals;
                actual.add((Subscription)this);
            }

            public void onError(Throwable e) {
                ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
                AppGlobals previous = AppGlobals.set(this.appGlobals);
                try {
                    this.actual.onError(e);
                }
                finally {
                    AppGlobals.set(previous);
                    ResteasyProviderFactory.removeContextDataLevel();
                }
            }

            public void onSuccess(T t) {
                ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
                AppGlobals previous = AppGlobals.set(this.appGlobals);
                try {
                    this.actual.onSuccess(t);
                }
                finally {
                    AppGlobals.set(previous);
                    ResteasyProviderFactory.removeContextDataLevel();
                }
            }
        }
    }
}

