/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.rxjava;

import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;

public class ResteasyContextPropagatingOnObservableCreateAction
implements Func1<Observable.OnSubscribe, Observable.OnSubscribe> {
    public Observable.OnSubscribe call(Observable.OnSubscribe t) {
        return new ContextCapturerSingle(t);
    }

    static final class ContextCapturerSingle<T>
    implements Observable.OnSubscribe<T> {
        final Map<Class<?>, Object> contextDataMap;
        final Observable.OnSubscribe<T> source;
        private AppGlobals appGlobals;

        public ContextCapturerSingle(Observable.OnSubscribe<T> source) {
            this.source = source;
            this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
            this.appGlobals = AppGlobals.get();
        }

        public void call(Subscriber<? super T> t) {
            this.source.call(new OnAssemblySingleSubscriber<T>(t, this.contextDataMap, this.appGlobals));
        }

        static final class OnAssemblySingleSubscriber<T>
        extends Subscriber<T> {
            final Subscriber<? super T> actual;
            final Map<Class<?>, Object> contextDataMap;
            private AppGlobals appGlobals;

            public OnAssemblySingleSubscriber(Subscriber<? super T> actual, Map<Class<?>, Object> contextDataMap, AppGlobals appGlobals) {
                this.actual = actual;
                this.contextDataMap = contextDataMap;
                this.appGlobals = appGlobals;
                actual.add((Subscription)this);
            }

            public void onError(Throwable e) {
                ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
                AppGlobals previous = AppGlobals.set(this.appGlobals);
                try {
                    this.actual.onError(e);
                }
                finally {
                    AppGlobals.set(previous);
                    ResteasyProviderFactory.removeContextDataLevel();
                }
            }

            public void onNext(T t) {
                ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
                AppGlobals previous = AppGlobals.set(this.appGlobals);
                try {
                    this.actual.onNext(t);
                }
                finally {
                    AppGlobals.set(previous);
                    ResteasyProviderFactory.removeContextDataLevel();
                }
            }

            public void onCompleted() {
                ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
                AppGlobals previous = AppGlobals.set(this.appGlobals);
                try {
                    this.actual.onCompleted();
                }
                finally {
                    AppGlobals.set(previous);
                    ResteasyProviderFactory.removeContextDataLevel();
                }
            }
        }
    }
}

