/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.core;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.swagger.jaxrs.config.ReaderConfigUtils;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Cookie;
import io.vertx.rxjava.config.ConfigRetriever;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.http.HttpServer;
import io.vertx.rxjava.ext.auth.AuthProvider;
import io.vertx.rxjava.ext.auth.User;
import io.vertx.rxjava.ext.jdbc.JDBCClient;
import io.vertx.rxjava.ext.sql.SQLClient;
import io.vertx.rxjava.ext.web.Router;
import io.vertx.rxjava.ext.web.RoutingContext;
import io.vertx.rxjava.ext.web.Session;
import io.vertx.rxjava.ext.web.handler.CookieHandler;
import io.vertx.rxjava.ext.web.handler.SessionHandler;
import io.vertx.rxjava.ext.web.sstore.LocalSessionStore;
import io.vertx.rxjava.ext.web.sstore.SessionStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import net.redpipe.engine.core.AppGlobals;
import net.redpipe.engine.core.MainResource;
import net.redpipe.engine.core.MyBeanConfig;
import net.redpipe.engine.dispatcher.VertxPluginRequestHandler;
import net.redpipe.engine.resteasy.RxVertxProvider;
import net.redpipe.engine.rxjava.ResteasyContextPropagatingOnSingleCreateAction;
import net.redpipe.engine.spi.Plugin;
import net.redpipe.engine.template.TemplateRenderer;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import rx.Single;
import rx.functions.Func1;
import rx.plugins.RxJavaHooks;

public class Server {
    private Vertx vertx;
    protected List<Plugin> plugins;
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    protected String configFile = "conf/config.json";

    public Single<Void> start() {
        return this.start((JsonObject)null, new Class[0]);
    }

    public Single<Void> start(Class<?> ... resourceOrProviderClasses) {
        return this.start((JsonObject)null, resourceOrProviderClasses);
    }

    public Single<Void> start(JsonObject defaultConfig, Class<?> ... resourceOrProviderClasses) {
        this.setupLogging();
        VertxOptions options = new VertxOptions();
        options.setWarningExceptionTime(Long.MAX_VALUE);
        AppGlobals.init();
        RxJavaHooks.setOnSingleCreate((Func1)new ResteasyContextPropagatingOnSingleCreateAction());
        JsonObject config = this.loadFileConfig(defaultConfig);
        AppGlobals.get().setConfig(config);
        return this.initVertx(config).flatMap(vertx -> {
            this.vertx = vertx;
            AppGlobals.get().setVertx(this.vertx);
            return this.setupPlugins();
        }).flatMap(v -> this.setupTemplateRenderers()).flatMap(v -> this.setupResteasy(resourceOrProviderClasses)).flatMap(deployment -> {
            this.setupSwagger((VertxResteasyDeployment)deployment);
            return this.setupVertx((VertxResteasyDeployment)deployment);
        });
    }

    private Single<Vertx> initVertx(JsonObject config) {
        VertxOptions options = config != null ? new VertxOptions(config) : new VertxOptions();
        options.setWarningExceptionTime(Long.MAX_VALUE);
        if (options.isClustered()) {
            return Vertx.rxClusteredVertx((VertxOptions)options);
        }
        this.vertx = Vertx.vertx((VertxOptions)options);
        return Single.just((Object)this.vertx);
    }

    private Single<Void> setupPlugins() {
        this.loadPlugins();
        return this.doOnPlugins(plugin -> plugin.preInit());
    }

    protected void loadPlugins() {
        this.plugins = new ArrayList<Plugin>();
        for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
            this.plugins.add(plugin);
        }
    }

    private Single<Void> setupTemplateRenderers() {
        ArrayList<TemplateRenderer> renderers = new ArrayList<TemplateRenderer>();
        for (TemplateRenderer renderer : ServiceLoader.load(TemplateRenderer.class)) {
            renderers.add(renderer);
        }
        AppGlobals.get().setTemplateRenderers(renderers);
        return Single.just(null);
    }

    private Single<Void> setupVertx(VertxResteasyDeployment deployment) {
        SQLClient dbClient = this.createDbClient(AppGlobals.get().getConfig());
        Class mainClass = null;
        for (Class resourceClass : deployment.getActualResourceClasses()) {
            if (resourceClass.getAnnotation(MainResource.class) == null) continue;
            mainClass = resourceClass;
            break;
        }
        AppGlobals globals = AppGlobals.get();
        globals.setDbClient(dbClient);
        globals.setMainClass(mainClass);
        globals.setDeployment(deployment);
        return this.doOnPlugins(plugin -> plugin.init()).flatMap(v -> this.startVertx(deployment));
    }

    protected SQLClient createDbClient(JsonObject config) {
        return JDBCClient.createNonShared((Vertx)this.vertx, (JsonObject)new JsonObject().put("url", config.getString("db_url", "jdbc:hsqldb:file:db/wiki")).put("driver_class", config.getString("db_driver", "org.hsqldb.jdbcDriver")).put("max_pool_size", config.getInteger("db_max_pool_size", Integer.valueOf(30))));
    }

    private Single<Void> doOnPlugins(Function<Plugin, Single<Void>> operation) {
        Single last = Single.just(null);
        for (Plugin plugin : this.plugins) {
            last = last.flatMap(v -> (Single)operation.apply(plugin));
        }
        return last;
    }

    private Single<Void> startVertx(VertxResteasyDeployment deployment) {
        Router router = Router.router((Vertx)this.vertx);
        AppGlobals.get().setRouter(router);
        VertxPluginRequestHandler resteasyHandler = new VertxPluginRequestHandler(this.vertx, (ResteasyDeployment)deployment, this.plugins);
        return this.doOnPlugins(plugin -> plugin.preRoute()).map(v -> {
            this.setupRoutes(router);
            router.route().handler(routingContext -> {
                ResteasyProviderFactory.pushContext(RoutingContext.class, (Object)routingContext);
                resteasyHandler.handle(routingContext.request());
            });
            return null;
        }).flatMap(v -> this.doOnPlugins(plugin -> plugin.postRoute())).flatMap(v -> Single.create(sub -> this.vertx.createHttpServer().requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(AppGlobals.get().getConfig().getInteger("http_port", Integer.valueOf(9000)).intValue(), ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
                sub.onError(ar.cause());
            } else {
                System.out.println("Server started on port " + ((HttpServer)ar.result()).actualPort());
                sub.onSuccess(null);
            }
        })));
    }

    protected void setupRoutes(Router router) {
        router.route().handler((Handler)CookieHandler.create());
        router.route().handler(context -> {
            context.addHeadersEndHandler(v -> {
                String previousValue;
                int currentStatusCode;
                Session session = context.session();
                if (!(session.isDestroyed() || (currentStatusCode = context.response().getStatusCode()) >= 200 && currentStatusCode < 400 || (previousValue = (String)context.get("__REDPIPE_SAVED_COOKIE")) == null)) {
                    io.netty.handler.codec.http.cookie.Cookie nettyCookie = ClientCookieDecoder.LAX.decode(previousValue);
                    io.vertx.rxjava.ext.web.Cookie newCookie = io.vertx.rxjava.ext.web.Cookie.newInstance((Cookie)Cookie.cookie((io.netty.handler.codec.http.cookie.Cookie)nettyCookie));
                    context.addCookie(newCookie);
                }
            });
            context.next();
        });
        SessionHandler sessionHandler = SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx));
        router.route().handler((Handler)sessionHandler);
        AuthProvider auth = this.setupAuthenticationRoutes();
        router.route().handler(context -> {
            context.addHeadersEndHandler(v -> {
                int currentStatusCode;
                Session session = context.session();
                if (!(session.isDestroyed() || (currentStatusCode = context.response().getStatusCode()) >= 200 && currentStatusCode < 400)) {
                    io.vertx.rxjava.ext.web.Cookie cookie = context.getCookie("vertx-web.session");
                    context.put("__REDPIPE_SAVED_COOKIE", (Object)cookie.encode());
                }
            });
            ResteasyProviderFactory.pushContext(AuthProvider.class, (Object)auth);
            ResteasyProviderFactory.pushContext(User.class, (Object)context.user());
            ResteasyProviderFactory.pushContext(Session.class, (Object)context.session());
            context.next();
        });
    }

    protected AuthProvider setupAuthenticationRoutes() {
        return null;
    }

    /*
     * Loose catch block
     */
    private JsonObject loadFileConfig(JsonObject config) {
        JsonObject jsonObject;
        String sconf;
        Throwable throwable;
        Scanner scanner;
        block23: {
            block24: {
                if (config != null) {
                    return config;
                }
                try {
                    File current = new File(".").getCanonicalFile();
                    System.setProperty("vertx.cwd", current.getAbsolutePath());
                }
                catch (Exception current) {
                    // empty catch block
                }
                String confArg = this.configFile;
                File file = new File(confArg);
                System.out.println(file.getAbsolutePath());
                scanner = new Scanner(new File(confArg)).useDelimiter("\\A");
                throwable = null;
                sconf = scanner.next();
                jsonObject = new JsonObject(sconf);
                if (scanner == null) break block23;
                if (throwable == null) break block24;
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block23;
            }
            scanner.close();
        }
        return jsonObject;
        {
            catch (DecodeException e) {
                JsonObject jsonObject2;
                block25: {
                    block26: {
                        log.error((Object)("Configuration file " + sconf + " does not contain a valid JSON object"));
                        jsonObject2 = new JsonObject();
                        if (scanner == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block25;
                    }
                    scanner.close();
                }
                return jsonObject2;
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (scanner != null) {
                                if (throwable != null) {
                                    try {
                                        scanner.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    scanner.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (FileNotFoundException e2) {
                        return new JsonObject();
                    }
                }
            }
        }
    }

    private Single<JsonObject> loadConfig(JsonObject config) {
        if (config != null) {
            AppGlobals.get().setConfig(config);
            return Single.just((Object)config);
        }
        String path = "conf/config.json";
        return this.vertx.fileSystem().rxExists(path).flatMap(exists -> {
            if (exists.booleanValue()) {
                ConfigStoreOptions fileStore = new ConfigStoreOptions().setType("file").setConfig(new JsonObject().put("path", path));
                ConfigRetrieverOptions configRetrieverOptions = new ConfigRetrieverOptions().addStore(fileStore);
                ConfigRetriever retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)configRetrieverOptions);
                return retriever.rxGetConfig().map(loadedConfig -> {
                    AppGlobals.get().setConfig((JsonObject)loadedConfig);
                    return loadedConfig;
                });
            }
            JsonObject emptyConfig = new JsonObject();
            AppGlobals.get().setConfig(emptyConfig);
            return Single.just((Object)emptyConfig);
        });
    }

    private void setupSwagger(VertxResteasyDeployment deployment) {
        ServletConfig servletConfig = new ServletConfig(){

            public String getServletName() {
                return "pretend-servlet";
            }

            public ServletContext getServletContext() {
                return RxVertxProvider.ServletContext;
            }

            public String getInitParameter(String name) {
                return this.getServletContext().getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return this.getServletContext().getInitParameterNames();
            }
        };
        AppGlobals.get().setGlobal(ServletConfig.class, servletConfig);
        ReaderConfigUtils.initReaderConfig((ServletConfig)servletConfig);
        MyBeanConfig swaggerConfig = new MyBeanConfig();
        swaggerConfig.setVersion("1.0");
        swaggerConfig.setSchemes(new String[]{"http"});
        swaggerConfig.setHost("localhost:" + AppGlobals.get().getConfig().getInteger("http_port", Integer.valueOf(9000)));
        swaggerConfig.setBasePath("/");
        HashSet<String> resourcePackages = new HashSet<String>();
        for (Class klass : deployment.getActualResourceClasses()) {
            resourcePackages.add(klass.getPackage().getName());
        }
        swaggerConfig.setResourcePackage(String.join((CharSequence)",", resourcePackages));
        swaggerConfig.setPrettyPrint(true);
        swaggerConfig.setScan(true);
        deployment.getRegistry().addPerInstanceResource(ApiListingResource.class);
        deployment.getProviderFactory().register(SwaggerSerializers.class);
    }

    protected Single<VertxResteasyDeployment> setupResteasy(Class<?> ... resourceOrProviderClasses) {
        VertxResteasyDeployment deployment = new VertxResteasyDeployment();
        deployment.getDefaultContextObjects().put(Vertx.class, AppGlobals.get().getVertx());
        deployment.getDefaultContextObjects().put(AppGlobals.class, AppGlobals.get());
        return this.doOnPlugins(plugin -> plugin.deployToResteasy(deployment)).map(v -> {
            for (Class klass : resourceOrProviderClasses) {
                if (klass.isAnnotationPresent(Path.class)) {
                    deployment.getActualResourceClasses().add(klass);
                }
                if (!klass.isAnnotationPresent(Provider.class)) continue;
                deployment.getActualProviderClasses().add(klass);
            }
            try {
                deployment.start();
            }
            catch (ExceptionInInitializerError err) {
                this.rethrow(err.getCause());
            }
            return deployment;
        }).doOnError(t -> t.printStackTrace());
    }

    private <T extends Throwable> void rethrow(Throwable cause) throws T {
        throw cause;
    }

    private void setupLogging() {
    }

    public Single<Void> close() {
        return this.doOnPlugins(plugin -> plugin.shutdown()).flatMap(v -> this.vertx.rxClose());
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public static void main(String[] args) {
        Server test = new Server();
        test.start();
    }
}

