/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.core;

import com.google.common.reflect.TypeToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.jaxrs.config.BeanConfig;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class MyBeanConfig
extends BeanConfig {
    public Set<Class<?>> classes() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        HashSet<String> acceptablePackages = new HashSet<String>();
        boolean allowAllPackages = false;
        String resourcePackage = this.getResourcePackage();
        if (resourcePackage != null && !"".equals(resourcePackage)) {
            String[] parts = resourcePackage.split(",");
            for (String pkg : parts) {
                if ("".equals(pkg)) continue;
                acceptablePackages.add(pkg);
                config.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            }
        } else {
            allowAllPackages = true;
        }
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        if (!allowAllPackages) {
            HashSet<String> acceptableBinaryPackages = new HashSet<String>();
            for (String pkg : acceptablePackages) {
                acceptableBinaryPackages.add(pkg.replace('.', '/'));
            }
            config.filterInputsBy(filePath -> {
                if (!filePath.toLowerCase().endsWith(".class")) {
                    return false;
                }
                int lastSlash = filePath.lastIndexOf(47);
                String binaryPkg = lastSlash == -1 ? "" : filePath.substring(0, lastSlash);
                boolean ret = acceptableBinaryPackages.contains(binaryPkg);
                return ret;
            });
        }
        Reflections reflections = new Reflections((Configuration)config);
        Set classes = reflections.getTypesAnnotatedWith(Path.class);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(SwaggerDefinition.class);
        classes.addAll(typesAnnotatedWith);
        block2: for (Class cls : reflections.getTypesAnnotatedWith(Api.class)) {
            for (Class intfc : TypeToken.of((Class)cls).getTypes().interfaces().rawTypes()) {
                Path ann = intfc.getAnnotation(Path.class);
                if (ann == null) continue;
                classes.add(cls);
                continue block2;
            }
        }
        HashSet output = new HashSet();
        block4: for (Class cls : classes) {
            if (allowAllPackages) {
                output.add(cls);
                continue;
            }
            for (String pkg : acceptablePackages) {
                if (!(cls.getPackage().getName() + ".").startsWith(pkg + ".")) continue;
                output.add(cls);
                continue block4;
            }
        }
        return output;
    }
}

