/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.engine.security;

import io.vertx.rxjava.ext.auth.User;
import java.lang.annotation.Annotation;
import net.redpipe.engine.security.AuthorizationException;
import net.redpipe.engine.security.AuthorizingAnnotationHandler;
import net.redpipe.engine.security.RequiresPermissions;
import rx.Single;

public class VertxPermissionAnnotationHandler
extends AuthorizingAnnotationHandler {
    @Override
    public Single<Boolean> assertAuthorized(Annotation authzSpec) {
        if (authzSpec instanceof RequiresPermissions) {
            User user = this.getUser();
            if (user == null) {
                return Single.error((Throwable)new AuthorizationException("User required"));
            }
            Single ret = Single.just((Object)true);
            for (String perm : ((RequiresPermissions)authzSpec).value()) {
                ret = user.rxIsAuthorised(perm).zipWith(ret, (a, b) -> a != false && b != false);
            }
            return ret;
        }
        return Single.just((Object)true);
    }
}

