/*
 * Decompiled with CFR 0.152.
 */
package net.rdrei.android.dirchooser;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.actionbarsherlock.app.SherlockActivity;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class DirectoryChooserActivity
extends SherlockActivity {
    public static final String EXTRA_NEW_DIR_NAME = "directory_name";
    public static final String RESULT_SELECTED_DIR = "selected_dir";
    public static final int RESULT_CODE_DIR_SELECTED = 1;
    private static final String TAG = "DirectoryChooser";
    private Button mBtnConfirm;
    private Button mBtnCancel;
    private ImageButton mBtnNavUp;
    private TextView mTxtvSelectedFolder;
    private ListView mListDirectories;
    private ArrayAdapter<String> mListDirectoriesAdapter;
    private ArrayList<String> mFilenames;
    private File mSelectedDir;
    private File[] mFilesInDir;
    private FileObserver mFileObserver;
    private String mNewDirectoryName;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setupActionBar();
        this.setContentView(2130903063);
        this.mNewDirectoryName = this.getIntent().getStringExtra(EXTRA_NEW_DIR_NAME);
        this.mBtnConfirm = (Button)this.findViewById(2130968628);
        this.mBtnCancel = (Button)this.findViewById(2130968629);
        this.mBtnNavUp = (ImageButton)this.findViewById(2130968631);
        this.mTxtvSelectedFolder = (TextView)this.findViewById(2130968633);
        this.mListDirectories = (ListView)this.findViewById(2130968635);
        this.mBtnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DirectoryChooserActivity.this.isValidFile(DirectoryChooserActivity.this.mSelectedDir)) {
                    DirectoryChooserActivity.this.returnSelectedFolder();
                }
            }
        });
        this.mBtnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DirectoryChooserActivity.this.setResult(0);
                DirectoryChooserActivity.this.finish();
            }
        });
        this.mListDirectories.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapter, View view, int position, long id2) {
                DirectoryChooserActivity.this.debug("Selected index: %d", new Object[]{position});
                if (DirectoryChooserActivity.this.mFilesInDir != null && position >= 0 && position < DirectoryChooserActivity.this.mFilesInDir.length) {
                    DirectoryChooserActivity.this.changeDirectory(DirectoryChooserActivity.this.mFilesInDir[position]);
                }
            }
        });
        this.mBtnNavUp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                File parent = null;
                if (DirectoryChooserActivity.this.mSelectedDir != null && (parent = DirectoryChooserActivity.this.mSelectedDir.getParentFile()) != null) {
                    DirectoryChooserActivity.this.changeDirectory(parent);
                }
            }
        });
        this.mFilenames = new ArrayList();
        this.mListDirectoriesAdapter = new ArrayAdapter((Context)this, 17367043, this.mFilenames);
        this.mListDirectories.setAdapter(this.mListDirectoriesAdapter);
        this.changeDirectory(Environment.getExternalStorageDirectory());
    }

    void setupActionBar() {
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    private void debug(String message, Object ... args) {
        Log.d((String)TAG, (String)String.format(message, args));
    }

    private void returnSelectedFolder() {
        if (this.mSelectedDir != null) {
            this.debug("Returning %s as result", this.mSelectedDir.getAbsolutePath());
        }
        Intent resultData = new Intent();
        if (this.mSelectedDir != null) {
            resultData.putExtra(RESULT_SELECTED_DIR, this.mSelectedDir.getAbsolutePath());
        }
        this.setResult(1, resultData);
        this.finish();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (this.mFileObserver != null) {
            this.mFileObserver.stopWatching();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mFileObserver != null) {
            this.mFileObserver.startWatching();
        }
    }

    private void changeDirectory(File dir) {
        if (dir == null) {
            this.debug("Could not change folder: dir was null", new Object[0]);
        } else if (!dir.isDirectory()) {
            this.debug("Could not change folder: dir is no directory", new Object[0]);
        } else {
            File[] contents = dir.listFiles();
            if (contents != null) {
                int numDirectories = 0;
                for (File f : contents) {
                    if (!f.isDirectory()) continue;
                    ++numDirectories;
                }
                this.mFilesInDir = new File[numDirectories];
                this.mFilenames.clear();
                int i = 0;
                int counter = 0;
                while (i < numDirectories) {
                    if (contents[counter].isDirectory()) {
                        this.mFilesInDir[i] = contents[counter];
                        this.mFilenames.add(contents[counter].getName());
                        ++i;
                    }
                    ++counter;
                }
                Arrays.sort(this.mFilesInDir);
                Collections.sort(this.mFilenames);
                this.mSelectedDir = dir;
                this.mTxtvSelectedFolder.setText((CharSequence)dir.getAbsolutePath());
                this.mListDirectoriesAdapter.notifyDataSetChanged();
                this.mFileObserver = this.createFileObserver(dir.getAbsolutePath());
                this.mFileObserver.startWatching();
                this.debug("Changed directory to %s", dir.getAbsolutePath());
            } else {
                this.debug("Could not change folder: contents of dir were null", new Object[0]);
            }
        }
        this.refreshButtonState();
    }

    private void refreshButtonState() {
        if (this.mSelectedDir != null) {
            this.mBtnConfirm.setEnabled(this.isValidFile(this.mSelectedDir));
            this.supportInvalidateOptionsMenu();
        }
    }

    private void refreshDirectory() {
        if (this.mSelectedDir != null) {
            this.changeDirectory(this.mSelectedDir);
        }
    }

    private FileObserver createFileObserver(String path) {
        return new FileObserver(path, 960){

            public void onEvent(int event, String path) {
                DirectoryChooserActivity.this.debug("FileObserver received event %d", new Object[]{event});
                DirectoryChooserActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DirectoryChooserActivity.this.refreshDirectory();
                    }
                });
            }
        };
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.findItem(2130968639).setVisible(this.isValidFile(this.mSelectedDir) && this.mNewDirectoryName != null);
        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = new MenuInflater((Context)this);
        inflater.inflate(2131427328, menu2);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == 16908332) {
            this.finish();
            return true;
        }
        if (itemId == 2130968639) {
            this.openNewFolderDialog();
            return true;
        }
        return false;
    }

    private void openNewFolderDialog() {
        new AlertDialog.Builder((Context)this).setTitle(2131296274).setMessage((CharSequence)String.format(this.getString(2131296275), this.mNewDirectoryName)).setNegativeButton(2131296271, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setPositiveButton(2131296272, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                int msg = DirectoryChooserActivity.this.createFolder();
                Toast t = Toast.makeText((Context)DirectoryChooserActivity.this, (int)msg, (int)0);
                t.show();
            }
        }).create().show();
    }

    private int createFolder() {
        if (this.mNewDirectoryName != null && this.mSelectedDir != null && this.mSelectedDir.canWrite()) {
            File newDir = new File(this.mSelectedDir, this.mNewDirectoryName);
            if (!newDir.exists()) {
                boolean result = newDir.mkdir();
                if (result) {
                    return 2131296276;
                }
                return 2131296279;
            }
            return 2131296278;
        }
        if (!this.mSelectedDir.canWrite()) {
            return 2131296277;
        }
        return 2131296279;
    }

    private boolean isValidFile(File file) {
        return file != null && file.isDirectory() && file.canRead() && file.canWrite();
    }
}

