/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal;

import android.app.Activity;
import android.content.Context;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.ActionBarSherlock;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.internal.app.ActionBarWrapper;
import com.actionbarsherlock.internal.view.menu.MenuWrapper;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.MenuInflater;

@ActionBarSherlock.Implementation(api=14)
public class ActionBarSherlockNative
extends ActionBarSherlock {
    private ActionBarWrapper mActionBar;
    private ActionModeWrapper mActionMode;
    private MenuWrapper mMenu;

    public ActionBarSherlockNative(Activity activity, int flags) {
        super(activity, flags);
    }

    @Override
    public ActionBar getActionBar() {
        this.initActionBar();
        return this.mActionBar;
    }

    private void initActionBar() {
        if (this.mActionBar != null || this.mActivity.getActionBar() == null) {
            return;
        }
        this.mActionBar = new ActionBarWrapper(this.mActivity);
    }

    @Override
    public void dispatchInvalidateOptionsMenu() {
        this.mActivity.getWindow().invalidatePanelMenu(0);
    }

    @Override
    public boolean dispatchCreateOptionsMenu(Menu menu2) {
        if (this.mMenu == null || menu2 != this.mMenu.unwrap()) {
            this.mMenu = new MenuWrapper(menu2);
        }
        boolean result = this.callbackCreateOptionsMenu(this.mMenu);
        return result;
    }

    @Override
    public boolean dispatchPrepareOptionsMenu(Menu menu2) {
        boolean result = this.callbackPrepareOptionsMenu(this.mMenu);
        return result;
    }

    @Override
    public boolean dispatchOptionsItemSelected(MenuItem item) {
        boolean result = this.callbackOptionsItemSelected(this.mMenu.findItem(item));
        return result;
    }

    @Override
    public boolean hasFeature(int feature) {
        boolean result = this.mActivity.getWindow().hasFeature(feature);
        return result;
    }

    @Override
    public boolean requestFeature(int featureId) {
        boolean result = this.mActivity.getWindow().requestFeature(featureId);
        return result;
    }

    @Override
    public void setUiOptions(int uiOptions) {
        this.mActivity.getWindow().setUiOptions(uiOptions);
    }

    @Override
    public void setUiOptions(int uiOptions, int mask) {
        this.mActivity.getWindow().setUiOptions(uiOptions, mask);
    }

    @Override
    public void setContentView(int layoutResId) {
        this.mActivity.getWindow().setContentView(layoutResId);
        this.initActionBar();
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        this.mActivity.getWindow().setContentView(view, params);
        this.initActionBar();
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.mActivity.getWindow().addContentView(view, params);
        this.initActionBar();
    }

    @Override
    public void setTitle(CharSequence title) {
        this.mActivity.getWindow().setTitle(title);
    }

    @Override
    public void setProgressBarVisibility(boolean visible) {
        this.mActivity.setProgressBarVisibility(visible);
    }

    @Override
    public void setProgressBarIndeterminateVisibility(boolean visible) {
        this.mActivity.setProgressBarIndeterminateVisibility(visible);
    }

    @Override
    public void setProgressBarIndeterminate(boolean indeterminate) {
        this.mActivity.setProgressBarIndeterminate(indeterminate);
    }

    @Override
    public void setProgress(int progress) {
        this.mActivity.setProgress(progress);
    }

    @Override
    public void setSecondaryProgress(int secondaryProgress) {
        this.mActivity.setSecondaryProgress(secondaryProgress);
    }

    @Override
    protected Context getThemedContext() {
        Activity context = this.mActivity;
        TypedValue outValue = new TypedValue();
        this.mActivity.getTheme().resolveAttribute(16843671, outValue, true);
        if (outValue.resourceId != 0) {
            context = new ContextThemeWrapper((Context)context, outValue.resourceId);
        }
        return context;
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        ActionModeCallbackWrapper wrapped = null;
        if (callback != null) {
            wrapped = new ActionModeCallbackWrapper(callback);
        }
        if (this.mActivity.startActionMode(wrapped) == null) {
            this.mActionMode = null;
        }
        if (this.mActivity instanceof ActionBarSherlock.OnActionModeStartedListener && this.mActionMode != null) {
            ((ActionBarSherlock.OnActionModeStartedListener)this.mActivity).onActionModeStarted(this.mActionMode);
        }
        return this.mActionMode;
    }

    private class ActionModeWrapper
    extends ActionMode {
        private final android.view.ActionMode mActionMode;
        private MenuWrapper mMenu = null;

        ActionModeWrapper(android.view.ActionMode actionMode) {
            this.mActionMode = actionMode;
        }

        @Override
        public void setTitle(CharSequence title) {
            this.mActionMode.setTitle(title);
        }

        @Override
        public void setTitle(int resId) {
            this.mActionMode.setTitle(resId);
        }

        @Override
        public void setSubtitle(CharSequence subtitle) {
            this.mActionMode.setSubtitle(subtitle);
        }

        @Override
        public void setSubtitle(int resId) {
            this.mActionMode.setSubtitle(resId);
        }

        @Override
        public void setCustomView(View view) {
            this.mActionMode.setCustomView(view);
        }

        @Override
        public void invalidate() {
            this.mActionMode.invalidate();
        }

        @Override
        public void finish() {
            this.mActionMode.finish();
        }

        @Override
        public MenuWrapper getMenu() {
            if (this.mMenu == null) {
                this.mMenu = new MenuWrapper(this.mActionMode.getMenu());
            }
            return this.mMenu;
        }

        @Override
        public CharSequence getTitle() {
            return this.mActionMode.getTitle();
        }

        @Override
        public CharSequence getSubtitle() {
            return this.mActionMode.getSubtitle();
        }

        @Override
        public View getCustomView() {
            return this.mActionMode.getCustomView();
        }

        @Override
        public MenuInflater getMenuInflater() {
            return ActionBarSherlockNative.this.getMenuInflater();
        }

        @Override
        public void setTag(Object tag) {
            this.mActionMode.setTag(tag);
        }

        @Override
        public Object getTag() {
            return this.mActionMode.getTag();
        }
    }

    private class ActionModeCallbackWrapper
    implements ActionMode.Callback {
        private final ActionMode.Callback mCallback;

        public ActionModeCallbackWrapper(ActionMode.Callback callback) {
            this.mCallback = callback;
        }

        public boolean onCreateActionMode(android.view.ActionMode mode, Menu menu2) {
            ActionBarSherlockNative.this.mActionMode = new ActionModeWrapper(mode);
            return this.mCallback.onCreateActionMode(ActionBarSherlockNative.this.mActionMode, ActionBarSherlockNative.this.mActionMode.getMenu());
        }

        public boolean onPrepareActionMode(android.view.ActionMode mode, Menu menu2) {
            return this.mCallback.onPrepareActionMode(ActionBarSherlockNative.this.mActionMode, ActionBarSherlockNative.this.mActionMode.getMenu());
        }

        public boolean onActionItemClicked(android.view.ActionMode mode, MenuItem item) {
            return this.mCallback.onActionItemClicked(ActionBarSherlockNative.this.mActionMode, ActionBarSherlockNative.this.mActionMode.getMenu().findItem(item));
        }

        public void onDestroyActionMode(android.view.ActionMode mode) {
            this.mCallback.onDestroyActionMode(ActionBarSherlockNative.this.mActionMode);
            if (ActionBarSherlockNative.this.mActivity instanceof ActionBarSherlock.OnActionModeFinishedListener) {
                ((ActionBarSherlock.OnActionModeFinishedListener)ActionBarSherlockNative.this.mActivity).onActionModeFinished(ActionBarSherlockNative.this.mActionMode);
            }
        }
    }
}

