/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.registration.solver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import net.raumzeitfalle.registration.solver.spi.SolverAdapter;

public class SolverProvider {
    private static String preferredSolverClass = null;
    private SolverAdapter preferredImplementation = null;
    private static SolverProvider service;
    private ServiceLoader<SolverAdapter> loader = ServiceLoader.load(SolverAdapter.class);

    public static void setPreferredImplementation(String className) {
        if ("".equalsIgnoreCase(className)) {
            throw new IllegalArgumentException("className must not be empty.");
        }
        if (!Objects.equals(className, preferredSolverClass)) {
            SolverProvider.getInstance().forceRediscovery();
        }
        preferredSolverClass = className;
    }

    public static synchronized SolverProvider getInstance() {
        if (service == null) {
            service = new SolverProvider();
        }
        return service;
    }

    private SolverProvider() {
    }

    protected List<SolverAdapter> getAllAvailableImplementations() {
        ArrayList<SolverAdapter> discoveredImplementations = new ArrayList<SolverAdapter>();
        for (SolverAdapter solver : this.loader) {
            discoveredImplementations.add(solver);
        }
        return discoveredImplementations;
    }

    public SolverAdapter getSolver() {
        if (this.preferredImplementation != null) {
            return this.preferredImplementation;
        }
        List<SolverAdapter> solver = this.getAllAvailableImplementations();
        if (preferredSolverClass != null) {
            Optional<SolverAdapter> option = solver.stream().filter(s -> s.getClass().getName().equals(preferredSolverClass)).findAny();
            if (option.isPresent()) {
                SolverAdapter newPreference = option.get();
                this.setPreferredSolver(newPreference);
                return newPreference;
            }
            throw new IllegalArgumentException(String.format("There is no solver with class [%s] configured.", preferredSolverClass));
        }
        SolverAdapter lastFound = this.getLastImplementation(solver);
        this.setPreferredSolver(lastFound);
        return this.preferredImplementation;
    }

    private void setPreferredSolver(SolverAdapter newPreference) {
        this.preferredImplementation = newPreference;
    }

    private void forceRediscovery() {
        this.preferredImplementation = null;
    }

    private SolverAdapter getLastImplementation(List<SolverAdapter> solver) {
        if (solver.isEmpty()) {
            throw new IllegalArgumentException("There is no solver implementation configured.");
        }
        return solver.get(solver.size() - 1);
    }
}

