/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser.locations;

import java.nio.file.Path;
import java.util.Objects;
import net.raumzeitfalle.fx.filechooser.locations.Location;

class NamedLocation
extends Location {
    private final String name;
    private final Path directory;

    protected NamedLocation(Path parent) {
        this(NamedLocation.createName(parent), parent);
    }

    private static String createName(Path location) {
        Objects.requireNonNull(location, "location must not be null");
        return location.toString();
    }

    protected NamedLocation(String name, Path path) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.directory = Objects.requireNonNull(path, "path must not be null");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.directory.toFile().exists();
    }

    @Override
    public Path getPath() {
        return this.directory;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

