/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import net.raumzeitfalle.fx.dirchooser.DirectoryChooser;
import net.raumzeitfalle.fx.filechooser.FXDirectoryChooser;
import net.raumzeitfalle.fx.filechooser.FileChooser;
import net.raumzeitfalle.fx.filechooser.FileChooserModel;
import net.raumzeitfalle.fx.filechooser.FileChooserViewOption;
import net.raumzeitfalle.fx.filechooser.HideableView;
import net.raumzeitfalle.fx.filechooser.PathFilter;
import net.raumzeitfalle.fx.filechooser.PathUpdateHandler;
import net.raumzeitfalle.fx.filechooser.Skin;
import net.raumzeitfalle.fx.filechooser.SwingFileChooserProperties;
import net.raumzeitfalle.fx.filechooser.locations.Location;

public class SwingFileChooser
extends JFXPanel
implements HideableView {
    private static final String CHOOSE_FILE_DIALOG_TITLE = "Choose file:";
    private static final long serialVersionUID = -5879082370711306802L;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private transient FileChooserModel model;
    private JDialog dialog;
    private String title;
    private String dirChooserTitle;

    public static void setUseJavaFxDirectoryChooser(boolean toggle) {
        SwingFileChooserProperties.setUseJavaFXDirectoryChooser(toggle);
    }

    public static SwingFileChooser create(Skin skin, PathFilter ... filter) {
        return SwingFileChooser.create(skin, CHOOSE_FILE_DIALOG_TITLE, ".", filter);
    }

    public static SwingFileChooser create(Skin skin, String title, PathFilter ... filter) {
        return SwingFileChooser.create(skin, title, ".", filter);
    }

    public static SwingFileChooser create(Skin skin, String title, String pathToBrowse, PathFilter ... filter) {
        return SwingFileChooser.create(skin, title, title, pathToBrowse, filter);
    }

    public static SwingFileChooser create(Skin skin, String title, String dirChooserTitle, String pathToBrowse, PathFilter ... filter) {
        String fcTitle = title == null ? CHOOSE_FILE_DIALOG_TITLE : title;
        String dcTitle = dirChooserTitle == null ? fcTitle : dirChooserTitle;
        Skin skinToUse = skin == null ? Skin.DARK : skin;
        String location = pathToBrowse == null ? "." : pathToBrowse;
        Path startHere = SwingFileChooser.startPath(location);
        PathFilter[] filters = filter;
        if (filters.length == 0) {
            filters = new PathFilter[]{PathFilter.acceptAllFiles()};
        }
        SwingFileChooser fc = new SwingFileChooser(fcTitle, dcTitle);
        fc.model = FileChooserModel.startingIn(startHere, new PathFilter[0]);
        for (PathFilter f : filters) {
            fc.model.addOrRemoveFilter(f);
        }
        Platform.runLater(() -> {
            PathUpdateHandler pathSupplier = SwingFileChooser.configureDirectoryChooser(skin, startHere, fc);
            FileChooser view = new FileChooser(pathSupplier, fc, fc.model, skinToUse, FileChooserViewOption.STAGE);
            Scene fileChooserScene = new Scene((Parent)view);
            fc.setScene(fileChooserScene);
        });
        return fc;
    }

    private static PathUpdateHandler configureDirectoryChooser(Skin skin, Path startHere, SwingFileChooser fc) {
        PathUpdateHandler onPathUpdate = null;
        if (SwingFileChooserProperties.usesJavaFXDirectoryChooser()) {
            onPathUpdate = FXDirectoryChooser.createIn(startHere, () -> fc.getScene().getWindow());
        } else {
            DirectoryChooser dirChooser = new DirectoryChooser(skin);
            dirChooser.useChooseFileButtonProperty().setValue(Boolean.valueOf(true));
            dirChooser.useCancelButtonProperty().setValue(Boolean.valueOf(true));
            Scene dirChooserScene = new Scene((Parent)dirChooser);
            onPathUpdate = update -> {
                Scene previousScene = fc.getScene();
                String previousTitle = fc.title;
                fc.setTitle(fc.dirChooserTitle);
                fc.setScene(dirChooserScene);
                dirChooser.onSelect(() -> {
                    Path selectedDir = (Path)dirChooser.selectedDirectoryProperty().get();
                    if (null != selectedDir) {
                        fc.setTitle(selectedDir.toString());
                        update.accept(selectedDir);
                    }
                    fc.setTitle(previousTitle);
                    fc.setScene(previousScene);
                });
                dirChooser.onCancel(() -> {
                    fc.setTitle(previousTitle);
                    fc.setScene(previousScene);
                });
            };
        }
        return onPathUpdate;
    }

    private static Path startPath(String pathToBrowse) {
        Path startHere = Paths.get(pathToBrowse, new String[0]);
        if (pathToBrowse.equals("")) {
            startHere = Paths.get("./", new String[0]);
        }
        if (Files.notExists(startHere, new LinkOption[0])) {
            return Paths.get("./", new String[0]);
        }
        return startHere;
    }

    private SwingFileChooser(String title, String dirChooserTitle) {
        this.title = null != title ? title : CHOOSE_FILE_DIALOG_TITLE;
        this.dirChooserTitle = null != dirChooserTitle ? dirChooserTitle : "Choose directory:";
    }

    public int showOpenDialog(Component parent) {
        if (null == this.dialog) {
            Frame frame = JOptionPane.getFrameForComponent(parent);
            this.dialog = new JDialog(frame, this.title, true);
            this.dialog.setContentPane((Container)((Object)this));
            Dimension size = new Dimension(750, 550);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.dialog.pack();
            this.dialog.setResizable(true);
        }
        this.dialog.setVisible(true);
        if (this.model.invalidSelectionProperty().getValue().booleanValue()) {
            return 1;
        }
        return 0;
    }

    public File getSelectedFile() {
        if (null != this.model.getSelectedFile()) {
            return this.model.getSelectedFile().toFile();
        }
        return null;
    }

    @Override
    public void closeView() {
        this.dialog.setVisible(false);
    }

    public void addLocations(List<Location> locations) {
        locations.forEach(this.model::addLocation);
    }

    protected void setTitle(String newTitle) {
        this.title = newTitle;
        this.dialog.setTitle(this.title);
    }
}

