/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import net.raumzeitfalle.fx.filechooser.FindFilesTask;
import net.raumzeitfalle.fx.filechooser.IndexedPath;

final class RefreshBuffer {
    private final List<IndexedPath> cache;
    private final AtomicReference<List<IndexedPath>> atomicCache;
    private final ReentrantLock lock = new ReentrantLock();
    private final ObservableList<IndexedPath> target;
    private final int desiredCacheSize;
    private final FindFilesTask task;

    static RefreshBuffer get(FindFilesTask task, int expectedNumberOfElements, ObservableList<IndexedPath> target) {
        int bufferSize = RefreshBuffer.determineBufferSize(expectedNumberOfElements);
        return new RefreshBuffer(task, bufferSize, target);
    }

    private RefreshBuffer(FindFilesTask task, int bufferSize, ObservableList<IndexedPath> target) {
        this.cache = new ArrayList<IndexedPath>(2 * bufferSize);
        this.target = target;
        this.desiredCacheSize = bufferSize;
        this.atomicCache = new AtomicReference<List<IndexedPath>>(this.cache);
        this.task = task;
    }

    void update(Path file) {
        this.cache.add(IndexedPath.valueOf(file));
        if (!this.task.isCancelled() && this.currentCacheSize() > this.desiredCacheSize) {
            this.flush();
        }
    }

    private int currentCacheSize() {
        return this.cache.size();
    }

    void flush() {
        this.lock.lock();
        try {
            IndexedPath[] update = this.atomicCache.get().toArray(new IndexedPath[0]);
            Platform.runLater(() -> this.target.addAll((Object[])update));
            this.atomicCache.get().clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    static int determineBufferSize(int items) {
        if (items > 500000) {
            return 1000;
        }
        if (items > 100000) {
            return 500;
        }
        if (items > 50000) {
            return 200;
        }
        if (items > 15000) {
            return 100;
        }
        if (items > 5000) {
            return 50;
        }
        if (items > 1000) {
            return 20;
        }
        return 10;
    }
}

