/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.util.Objects;
import javafx.scene.control.MenuItem;
import net.raumzeitfalle.fx.filechooser.locations.Location;

class LocationMenuItem
extends MenuItem {
    private final Location location;

    LocationMenuItem(Location location) {
        this.location = Objects.requireNonNull(location, "Given location instance must never be null.");
        this.setText(location.getName());
        this.setDisable(!location.exists());
    }

    public boolean matchesLocation(Location otherLocation) {
        return this.location.equals(otherLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationMenuItem)) {
            return false;
        }
        LocationMenuItem that = (LocationMenuItem)((Object)o);
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode() + 13;
    }
}

