/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;

class Invoke {
    private Invoke() {
    }

    static void later(Supplier<Void> action) {
        Platform.runLater(action::get);
    }

    static <T> void later(T value, Consumer<T> consumingAction) {
        Platform.runLater(() -> consumingAction.accept(value));
    }

    static void laterWithDelay(Duration duration, Runnable r) {
        Platform.runLater(() -> {
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            r.run();
        });
    }

    static void andWaitWithoutException(Runnable r) {
        try {
            Invoke.andWait(r);
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
    }

    static void andWait(Runnable r) throws InterruptedException, ExecutionException {
        FutureTask<Object> task = new FutureTask<Object>(r, null);
        Platform.runLater(task);
        task.get();
    }
}

