/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class IndexedPath {
    private static final Logger LOGGER = Logger.getLogger(IndexedPath.class.getName());
    private final byte[] fileName;
    private final long timestamp;

    public static IndexedPath valueOf(Path path) {
        FileTime timestamp;
        try {
            timestamp = IndexedPath.getTimestamp(path);
        }
        catch (IOException e) {
            timestamp = FileTime.from(0L, TimeUnit.MICROSECONDS);
            String message = String.format("Could not determine lastModified timestamp for %s, returning %s instead.", path, timestamp);
            LOGGER.log(Level.SEVERE, message, e);
        }
        return new IndexedPath(path, timestamp);
    }

    private static FileTime getTimestamp(Path path) throws IOException {
        FileTime created;
        BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        FileTime lastModified = attributes.lastModifiedTime();
        if (lastModified.compareTo(created = attributes.creationTime()) > 0) {
            return lastModified;
        }
        return created;
    }

    IndexedPath(Path path, FileTime timestamp) {
        this.fileName = path.getFileName().toString().getBytes();
        this.timestamp = timestamp.to(TimeUnit.MILLISECONDS);
    }

    public final FileTime getTimestamp() {
        return FileTime.from(this.timestamp, TimeUnit.MILLISECONDS);
    }

    public final Path asPath(Path location) {
        return location.resolve(this.toString());
    }

    public final String toString() {
        return new String(this.fileName);
    }

    int compareByName(IndexedPath other) {
        return this.toString().compareTo(other.toString());
    }
}

