/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import net.raumzeitfalle.fx.filechooser.IndexedPath;
import net.raumzeitfalle.fx.filechooser.Invoke;
import net.raumzeitfalle.fx.filechooser.RefreshBuffer;

final class FindFilesTask
extends Task<Integer> {
    private static final Logger LOGGER = Logger.getLogger(FindFilesTask.class.getName());
    private final ObservableList<IndexedPath> pathsToUpdate;
    private final Path directory;
    private final DoubleProperty duration;

    public FindFilesTask(Path searchFolder, ObservableList<IndexedPath> listOfPaths) {
        this.pathsToUpdate = Objects.requireNonNull(listOfPaths, "listOfPaths must not be null");
        this.directory = searchFolder;
        this.duration = new SimpleDoubleProperty(0.0);
    }

    protected Integer call() throws Exception {
        Invoke.andWait(() -> this.pathsToUpdate.clear());
        long start = System.currentTimeMillis();
        if (null == this.directory) {
            return 0;
        }
        File[] files = this.directory.toAbsolutePath().toFile().listFiles();
        if (null == files) {
            return 0;
        }
        if (files.length == 0) {
            return 0;
        }
        this.updateProgress(0L, files.length);
        int progressIntervall = this.getProgressInterval(files.length);
        RefreshBuffer buffer = RefreshBuffer.get(this, files.length, this.pathsToUpdate);
        for (int f = 0; f < files.length; ++f) {
            if (this.isCancelled()) {
                this.updateProgress(f, files.length);
                this.duration.set((double)(System.currentTimeMillis() - start) / 1000.0);
                buffer.flush();
                return f;
            }
            if (f % progressIntervall == 0) {
                this.updateProgress((long)f + 1L, files.length);
            }
            if (!files[f].isFile()) continue;
            buffer.update(files[f].toPath());
        }
        buffer.flush();
        this.updateProgress(files.length, files.length);
        this.duration.set((double)(System.currentTimeMillis() - start) / 1000.0);
        return files.length;
    }

    protected void running() {
        super.running();
        Logger.getLogger(FindFilesTask.class.getName()).log(Level.INFO, "in {0}", this.directory.normalize().toAbsolutePath());
    }

    protected void succeeded() {
        super.succeeded();
        LOGGER.log(Level.INFO, "with {0} files out of {1} entries after {2} sec", new Object[]{this.pathsToUpdate.size(), this.getValue(), this.duration.get()});
    }

    protected void cancelled() {
        super.cancelled();
        LOGGER.log(Level.INFO, "with {0} files after {1} seconds!", new Object[]{this.pathsToUpdate.size(), this.duration.get()});
    }

    protected void failed() {
        super.failed();
        String message = String.format("after indexing %s files with an error.", this.pathsToUpdate.size());
        LOGGER.log(Level.WARNING, message, this.getException());
    }

    protected int getProgressInterval(int length) {
        int divider = 1;
        if (length >= 200) {
            divider = length / 200;
        }
        return divider;
    }
}

