/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import net.raumzeitfalle.fx.filechooser.FileIcons;
import net.raumzeitfalle.fx.filechooser.IndexedPath;

class FilesListCell
extends ListCell<IndexedPath> {
    private static final String DATE_TIME_FORMAT_PATTERN = "yyyy-MM-dd  -  HH:mm:ss";
    private static final String FILE_ICON_LABEL = "file-icon-label";

    FilesListCell() {
    }

    protected void updateItem(IndexedPath item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.updateView();
    }

    private void updateView() {
        if (this.getItem() != null) {
            GridPane gridPane = new GridPane();
            gridPane.getStyleClass().add((Object)FILE_ICON_LABEL);
            StackPane icon = FileIcons.fromFile((IndexedPath)this.getItem());
            icon.setId("fileListCell-fileTypeIcon");
            gridPane.addColumn(0, new Node[]{icon});
            GridPane.setHgrow((Node)icon, (Priority)Priority.SOMETIMES);
            Label fileName = new Label(String.valueOf(this.getItem()));
            fileName.getStyleClass().add((Object)FILE_ICON_LABEL);
            fileName.setId("fileListCell-fileName");
            gridPane.addColumn(1, new Node[]{fileName});
            GridPane.setHgrow((Node)fileName, (Priority)Priority.ALWAYS);
            Label date = new Label("");
            FileTime time = ((IndexedPath)this.getItem()).getTimestamp();
            LocalDateTime timestamp = LocalDateTime.from(time.toInstant().atZone(ZoneId.systemDefault()));
            date.setText(DateTimeFormatter.ofPattern(DATE_TIME_FORMAT_PATTERN).format(timestamp));
            date.setId("fileListCell-fileDate");
            date.getStyleClass().add((Object)FILE_ICON_LABEL);
            gridPane.addColumn(2, new Node[]{date});
            GridPane.setHgrow((Node)date, (Priority)Priority.NEVER);
            this.setGraphic((Node)gridPane);
        } else {
            this.setText(null);
            this.setGraphic(null);
        }
    }
}

