/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.nio.file.Path;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import net.raumzeitfalle.fx.filechooser.FindFilesTask;
import net.raumzeitfalle.fx.filechooser.IndexedPath;
import net.raumzeitfalle.fx.filechooser.UpdateService;

final class FileUpdateService
extends Service<Integer>
implements UpdateService {
    private ObjectProperty<Path> rootFolder = new SimpleObjectProperty();
    private ObservableList<IndexedPath> pathsToUpdate;
    private Thread shutdownThread = null;

    public FileUpdateService(Path folderToStart, ObservableList<IndexedPath> paths) {
        this.setSearchLocation(folderToStart);
        this.assignTargetCollection(paths);
        this.registerShutdownHook();
    }

    private void assignTargetCollection(ObservableList<IndexedPath> paths) {
        this.pathsToUpdate = Objects.requireNonNull(paths, "Target collection paths must not be null");
    }

    private void setSearchLocation(Path folderToStart) {
        this.rootFolder.setValue((Object)this.obtainDirectory(folderToStart));
    }

    private Path obtainDirectory(Path folderToStart) {
        if (null == folderToStart) {
            return null;
        }
        if (folderToStart.toFile().isDirectory()) {
            return folderToStart;
        }
        return folderToStart.getParent();
    }

    protected Task<Integer> createTask() {
        return new FindFilesTask((Path)this.rootFolder.getValue(), this.pathsToUpdate);
    }

    @Override
    public void restartIn(Path directory) {
        if (null != directory) {
            this.restartInDirectory(directory);
        }
    }

    @Override
    public ObjectProperty<Path> searchPathProperty() {
        return this.rootFolder;
    }

    @Override
    public void refresh() {
        this.restart();
    }

    @Override
    public void cancelUpdate() {
        this.cancel();
    }

    @Override
    public void startUpdate() {
        this.start();
    }

    private void restartInDirectory(Path directory) {
        if (directory.toFile().isDirectory()) {
            this.refreshWhenExists(directory);
        } else {
            this.attemptRefreshUsingParent(directory);
        }
    }

    private void attemptRefreshUsingParent(Path directory) {
        Path parent = directory.getParent();
        if (null != parent) {
            this.refreshWhenExists(parent);
        }
    }

    protected void refreshWhenExists(Path location) {
        if (location.toFile().exists()) {
            this.setLocationAndRefresh(location);
        }
    }

    private void setLocationAndRefresh(Path location) {
        this.setSearchLocation(location);
        this.refresh();
    }

    private void registerShutdownHook() {
        Runnable shutDownAction = () -> Platform.runLater(this::cancelUpdate);
        this.shutdownThread = new Thread(shutDownAction);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    protected Thread getShutdownThread() {
        return this.shutdownThread;
    }
}

